import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Cognito
*/
export interface DataAwsCognitoUserPoolClientsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/cognito_user_pool_clients#user_pool_id DataAwsCognitoUserPoolClients#user_pool_id}
    */
    readonly userPoolId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/cognito_user_pool_clients aws_cognito_user_pool_clients}
*/
export declare class DataAwsCognitoUserPoolClients extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_cognito_user_pool_clients";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/cognito_user_pool_clients aws_cognito_user_pool_clients} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsCognitoUserPoolClientsConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsCognitoUserPoolClientsConfig);
    get clientIds(): string[];
    get clientNames(): string[];
    get id(): string;
    private _userPoolId?;
    get userPoolId(): string;
    set userPoolId(value: string);
    get userPoolIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-cognito-user-pool-clients.d.ts.map