import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Connect
*/
export interface ConnectBotAssociationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/connect_bot_association#instance_id ConnectBotAssociation#instance_id}
    */
    readonly instanceId: string;
    /**
    * lex_bot block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/connect_bot_association#lex_bot ConnectBotAssociation#lex_bot}
    */
    readonly lexBot: ConnectBotAssociationLexBot;
}
export interface ConnectBotAssociationLexBot {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/connect_bot_association#lex_region ConnectBotAssociation#lex_region}
    */
    readonly lexRegion?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/connect_bot_association#name ConnectBotAssociation#name}
    */
    readonly name: string;
}
export declare function connectBotAssociationLexBotToTerraform(struct?: ConnectBotAssociationLexBotOutputReference | ConnectBotAssociationLexBot): any;
export declare class ConnectBotAssociationLexBotOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ConnectBotAssociationLexBot | undefined;
    set internalValue(value: ConnectBotAssociationLexBot | undefined);
    private _lexRegion?;
    get lexRegion(): string;
    set lexRegion(value: string);
    resetLexRegion(): void;
    get lexRegionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/connect_bot_association aws_connect_bot_association}
*/
export declare class ConnectBotAssociation extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_connect_bot_association";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/connect_bot_association aws_connect_bot_association} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ConnectBotAssociationConfig
    */
    constructor(scope: Construct, id: string, config: ConnectBotAssociationConfig);
    get id(): string;
    private _instanceId?;
    get instanceId(): string;
    set instanceId(value: string);
    get instanceIdInput(): string | undefined;
    private _lexBot;
    get lexBot(): ConnectBotAssociationLexBotOutputReference;
    putLexBot(value: ConnectBotAssociationLexBot): void;
    get lexBotInput(): ConnectBotAssociationLexBot | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=connect-bot-association.d.ts.map