import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Connect
*/
export interface ConnectQuickConnectConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/connect_quick_connect#description ConnectQuickConnect#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/connect_quick_connect#instance_id ConnectQuickConnect#instance_id}
    */
    readonly instanceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/connect_quick_connect#name ConnectQuickConnect#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/connect_quick_connect#tags ConnectQuickConnect#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/connect_quick_connect#tags_all ConnectQuickConnect#tags_all}
    */
    readonly tagsAll?: {
        [key: string]: string;
    };
    /**
    * quick_connect_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/connect_quick_connect#quick_connect_config ConnectQuickConnect#quick_connect_config}
    */
    readonly quickConnectConfig: ConnectQuickConnectQuickConnectConfig;
}
export interface ConnectQuickConnectQuickConnectConfigPhoneConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/connect_quick_connect#phone_number ConnectQuickConnect#phone_number}
    */
    readonly phoneNumber: string;
}
export declare function connectQuickConnectQuickConnectConfigPhoneConfigToTerraform(struct?: ConnectQuickConnectQuickConnectConfigPhoneConfig | cdktf.IResolvable): any;
export interface ConnectQuickConnectQuickConnectConfigQueueConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/connect_quick_connect#contact_flow_id ConnectQuickConnect#contact_flow_id}
    */
    readonly contactFlowId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/connect_quick_connect#queue_id ConnectQuickConnect#queue_id}
    */
    readonly queueId: string;
}
export declare function connectQuickConnectQuickConnectConfigQueueConfigToTerraform(struct?: ConnectQuickConnectQuickConnectConfigQueueConfig | cdktf.IResolvable): any;
export interface ConnectQuickConnectQuickConnectConfigUserConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/connect_quick_connect#contact_flow_id ConnectQuickConnect#contact_flow_id}
    */
    readonly contactFlowId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/connect_quick_connect#user_id ConnectQuickConnect#user_id}
    */
    readonly userId: string;
}
export declare function connectQuickConnectQuickConnectConfigUserConfigToTerraform(struct?: ConnectQuickConnectQuickConnectConfigUserConfig | cdktf.IResolvable): any;
export interface ConnectQuickConnectQuickConnectConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/connect_quick_connect#quick_connect_type ConnectQuickConnect#quick_connect_type}
    */
    readonly quickConnectType: string;
    /**
    * phone_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/connect_quick_connect#phone_config ConnectQuickConnect#phone_config}
    */
    readonly phoneConfig?: ConnectQuickConnectQuickConnectConfigPhoneConfig[] | cdktf.IResolvable;
    /**
    * queue_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/connect_quick_connect#queue_config ConnectQuickConnect#queue_config}
    */
    readonly queueConfig?: ConnectQuickConnectQuickConnectConfigQueueConfig[] | cdktf.IResolvable;
    /**
    * user_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/connect_quick_connect#user_config ConnectQuickConnect#user_config}
    */
    readonly userConfig?: ConnectQuickConnectQuickConnectConfigUserConfig[] | cdktf.IResolvable;
}
export declare function connectQuickConnectQuickConnectConfigToTerraform(struct?: ConnectQuickConnectQuickConnectConfigOutputReference | ConnectQuickConnectQuickConnectConfig): any;
export declare class ConnectQuickConnectQuickConnectConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ConnectQuickConnectQuickConnectConfig | undefined;
    set internalValue(value: ConnectQuickConnectQuickConnectConfig | undefined);
    private _quickConnectType?;
    get quickConnectType(): string;
    set quickConnectType(value: string);
    get quickConnectTypeInput(): string | undefined;
    private _phoneConfig?;
    get phoneConfig(): ConnectQuickConnectQuickConnectConfigPhoneConfig[] | cdktf.IResolvable;
    set phoneConfig(value: ConnectQuickConnectQuickConnectConfigPhoneConfig[] | cdktf.IResolvable);
    resetPhoneConfig(): void;
    get phoneConfigInput(): cdktf.IResolvable | ConnectQuickConnectQuickConnectConfigPhoneConfig[] | undefined;
    private _queueConfig?;
    get queueConfig(): ConnectQuickConnectQuickConnectConfigQueueConfig[] | cdktf.IResolvable;
    set queueConfig(value: ConnectQuickConnectQuickConnectConfigQueueConfig[] | cdktf.IResolvable);
    resetQueueConfig(): void;
    get queueConfigInput(): cdktf.IResolvable | ConnectQuickConnectQuickConnectConfigQueueConfig[] | undefined;
    private _userConfig?;
    get userConfig(): ConnectQuickConnectQuickConnectConfigUserConfig[] | cdktf.IResolvable;
    set userConfig(value: ConnectQuickConnectQuickConnectConfigUserConfig[] | cdktf.IResolvable);
    resetUserConfig(): void;
    get userConfigInput(): cdktf.IResolvable | ConnectQuickConnectQuickConnectConfigUserConfig[] | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/connect_quick_connect aws_connect_quick_connect}
*/
export declare class ConnectQuickConnect extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_connect_quick_connect";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/connect_quick_connect aws_connect_quick_connect} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ConnectQuickConnectConfig
    */
    constructor(scope: Construct, id: string, config: ConnectQuickConnectConfig);
    get arn(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _instanceId?;
    get instanceId(): string;
    set instanceId(value: string);
    get instanceIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get quickConnectId(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tagsAll?;
    get tagsAll(): {
        [key: string]: string;
    };
    set tagsAll(value: {
        [key: string]: string;
    });
    resetTagsAll(): void;
    get tagsAllInput(): {
        [key: string]: string;
    } | undefined;
    private _quickConnectConfig;
    get quickConnectConfig(): ConnectQuickConnectQuickConnectConfigOutputReference;
    putQuickConnectConfig(value: ConnectQuickConnectQuickConnectConfig): void;
    get quickConnectConfigInput(): ConnectQuickConnectQuickConnectConfig | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=connect-quick-connect.d.ts.map