import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Connect
*/
export interface ConnectRoutingProfileConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/connect_routing_profile#default_outbound_queue_id ConnectRoutingProfile#default_outbound_queue_id}
    */
    readonly defaultOutboundQueueId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/connect_routing_profile#description ConnectRoutingProfile#description}
    */
    readonly description: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/connect_routing_profile#instance_id ConnectRoutingProfile#instance_id}
    */
    readonly instanceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/connect_routing_profile#name ConnectRoutingProfile#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/connect_routing_profile#tags ConnectRoutingProfile#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/connect_routing_profile#tags_all ConnectRoutingProfile#tags_all}
    */
    readonly tagsAll?: {
        [key: string]: string;
    };
    /**
    * media_concurrencies block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/connect_routing_profile#media_concurrencies ConnectRoutingProfile#media_concurrencies}
    */
    readonly mediaConcurrencies: ConnectRoutingProfileMediaConcurrencies[] | cdktf.IResolvable;
    /**
    * queue_configs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/connect_routing_profile#queue_configs ConnectRoutingProfile#queue_configs}
    */
    readonly queueConfigs?: ConnectRoutingProfileQueueConfigs[] | cdktf.IResolvable;
}
export interface ConnectRoutingProfileQueueConfigsAssociated {
}
export declare function connectRoutingProfileQueueConfigsAssociatedToTerraform(struct?: ConnectRoutingProfileQueueConfigsAssociated): any;
export declare class ConnectRoutingProfileQueueConfigsAssociatedOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ConnectRoutingProfileQueueConfigsAssociated | undefined;
    set internalValue(value: ConnectRoutingProfileQueueConfigsAssociated | undefined);
    get channel(): string;
    get delay(): number;
    get priority(): number;
    get queueArn(): string;
    get queueId(): string;
    get queueName(): string;
}
export declare class ConnectRoutingProfileQueueConfigsAssociatedList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ConnectRoutingProfileQueueConfigsAssociatedOutputReference;
}
export interface ConnectRoutingProfileMediaConcurrencies {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/connect_routing_profile#channel ConnectRoutingProfile#channel}
    */
    readonly channel: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/connect_routing_profile#concurrency ConnectRoutingProfile#concurrency}
    */
    readonly concurrency: number;
}
export declare function connectRoutingProfileMediaConcurrenciesToTerraform(struct?: ConnectRoutingProfileMediaConcurrencies | cdktf.IResolvable): any;
export interface ConnectRoutingProfileQueueConfigs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/connect_routing_profile#channel ConnectRoutingProfile#channel}
    */
    readonly channel: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/connect_routing_profile#delay ConnectRoutingProfile#delay}
    */
    readonly delay: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/connect_routing_profile#priority ConnectRoutingProfile#priority}
    */
    readonly priority: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/connect_routing_profile#queue_id ConnectRoutingProfile#queue_id}
    */
    readonly queueId: string;
}
export declare function connectRoutingProfileQueueConfigsToTerraform(struct?: ConnectRoutingProfileQueueConfigs | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/connect_routing_profile aws_connect_routing_profile}
*/
export declare class ConnectRoutingProfile extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_connect_routing_profile";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/connect_routing_profile aws_connect_routing_profile} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ConnectRoutingProfileConfig
    */
    constructor(scope: Construct, id: string, config: ConnectRoutingProfileConfig);
    get arn(): string;
    private _defaultOutboundQueueId?;
    get defaultOutboundQueueId(): string;
    set defaultOutboundQueueId(value: string);
    get defaultOutboundQueueIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    get descriptionInput(): string | undefined;
    get id(): string;
    private _instanceId?;
    get instanceId(): string;
    set instanceId(value: string);
    get instanceIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _queueConfigsAssociated;
    get queueConfigsAssociated(): ConnectRoutingProfileQueueConfigsAssociatedList;
    get routingProfileId(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tagsAll?;
    get tagsAll(): {
        [key: string]: string;
    };
    set tagsAll(value: {
        [key: string]: string;
    });
    resetTagsAll(): void;
    get tagsAllInput(): {
        [key: string]: string;
    } | undefined;
    private _mediaConcurrencies?;
    get mediaConcurrencies(): ConnectRoutingProfileMediaConcurrencies[] | cdktf.IResolvable;
    set mediaConcurrencies(value: ConnectRoutingProfileMediaConcurrencies[] | cdktf.IResolvable);
    get mediaConcurrenciesInput(): cdktf.IResolvable | ConnectRoutingProfileMediaConcurrencies[] | undefined;
    private _queueConfigs?;
    get queueConfigs(): ConnectRoutingProfileQueueConfigs[] | cdktf.IResolvable;
    set queueConfigs(value: ConnectRoutingProfileQueueConfigs[] | cdktf.IResolvable);
    resetQueueConfigs(): void;
    get queueConfigsInput(): cdktf.IResolvable | ConnectRoutingProfileQueueConfigs[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=connect-routing-profile.d.ts.map