import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Connect
*/
export interface DataAwsConnectBotAssociationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/connect_bot_association#instance_id DataAwsConnectBotAssociation#instance_id}
    */
    readonly instanceId: string;
    /**
    * lex_bot block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/connect_bot_association#lex_bot DataAwsConnectBotAssociation#lex_bot}
    */
    readonly lexBot: DataAwsConnectBotAssociationLexBot;
}
export interface DataAwsConnectBotAssociationLexBot {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/connect_bot_association#lex_region DataAwsConnectBotAssociation#lex_region}
    */
    readonly lexRegion?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/connect_bot_association#name DataAwsConnectBotAssociation#name}
    */
    readonly name: string;
}
export declare function dataAwsConnectBotAssociationLexBotToTerraform(struct?: DataAwsConnectBotAssociationLexBotOutputReference | DataAwsConnectBotAssociationLexBot): any;
export declare class DataAwsConnectBotAssociationLexBotOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAwsConnectBotAssociationLexBot | undefined;
    set internalValue(value: DataAwsConnectBotAssociationLexBot | undefined);
    private _lexRegion?;
    get lexRegion(): string;
    set lexRegion(value: string);
    resetLexRegion(): void;
    get lexRegionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/connect_bot_association aws_connect_bot_association}
*/
export declare class DataAwsConnectBotAssociation extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_connect_bot_association";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/connect_bot_association aws_connect_bot_association} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsConnectBotAssociationConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsConnectBotAssociationConfig);
    get id(): string;
    private _instanceId?;
    get instanceId(): string;
    set instanceId(value: string);
    get instanceIdInput(): string | undefined;
    private _lexBot;
    get lexBot(): DataAwsConnectBotAssociationLexBotOutputReference;
    putLexBot(value: DataAwsConnectBotAssociationLexBot): void;
    get lexBotInput(): DataAwsConnectBotAssociationLexBot | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-connect-bot-association.d.ts.map