import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Cost and Usage Report
*/
export interface CurReportDefinitionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cur_report_definition#additional_artifacts CurReportDefinition#additional_artifacts}
    */
    readonly additionalArtifacts?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cur_report_definition#additional_schema_elements CurReportDefinition#additional_schema_elements}
    */
    readonly additionalSchemaElements: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cur_report_definition#compression CurReportDefinition#compression}
    */
    readonly compression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cur_report_definition#format CurReportDefinition#format}
    */
    readonly format: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cur_report_definition#refresh_closed_reports CurReportDefinition#refresh_closed_reports}
    */
    readonly refreshClosedReports?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cur_report_definition#report_name CurReportDefinition#report_name}
    */
    readonly reportName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cur_report_definition#report_versioning CurReportDefinition#report_versioning}
    */
    readonly reportVersioning?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cur_report_definition#s3_bucket CurReportDefinition#s3_bucket}
    */
    readonly s3Bucket: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cur_report_definition#s3_prefix CurReportDefinition#s3_prefix}
    */
    readonly s3Prefix?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cur_report_definition#s3_region CurReportDefinition#s3_region}
    */
    readonly s3Region: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cur_report_definition#time_unit CurReportDefinition#time_unit}
    */
    readonly timeUnit: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/cur_report_definition aws_cur_report_definition}
*/
export declare class CurReportDefinition extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_cur_report_definition";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/cur_report_definition aws_cur_report_definition} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CurReportDefinitionConfig
    */
    constructor(scope: Construct, id: string, config: CurReportDefinitionConfig);
    private _additionalArtifacts?;
    get additionalArtifacts(): string[];
    set additionalArtifacts(value: string[]);
    resetAdditionalArtifacts(): void;
    get additionalArtifactsInput(): string[] | undefined;
    private _additionalSchemaElements?;
    get additionalSchemaElements(): string[];
    set additionalSchemaElements(value: string[]);
    get additionalSchemaElementsInput(): string[] | undefined;
    get arn(): string;
    private _compression?;
    get compression(): string;
    set compression(value: string);
    get compressionInput(): string | undefined;
    private _format?;
    get format(): string;
    set format(value: string);
    get formatInput(): string | undefined;
    get id(): string;
    private _refreshClosedReports?;
    get refreshClosedReports(): boolean | cdktf.IResolvable;
    set refreshClosedReports(value: boolean | cdktf.IResolvable);
    resetRefreshClosedReports(): void;
    get refreshClosedReportsInput(): boolean | cdktf.IResolvable | undefined;
    private _reportName?;
    get reportName(): string;
    set reportName(value: string);
    get reportNameInput(): string | undefined;
    private _reportVersioning?;
    get reportVersioning(): string;
    set reportVersioning(value: string);
    resetReportVersioning(): void;
    get reportVersioningInput(): string | undefined;
    private _s3Bucket?;
    get s3Bucket(): string;
    set s3Bucket(value: string);
    get s3BucketInput(): string | undefined;
    private _s3Prefix?;
    get s3Prefix(): string;
    set s3Prefix(value: string);
    resetS3Prefix(): void;
    get s3PrefixInput(): string | undefined;
    private _s3Region?;
    get s3Region(): string;
    set s3Region(value: string);
    get s3RegionInput(): string | undefined;
    private _timeUnit?;
    get timeUnit(): string;
    set timeUnit(value: string);
    get timeUnitInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=cur-report-definition.d.ts.map