import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAwsCeTagsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#search_string DataAwsCeTags#search_string}
    */
    readonly searchString?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#tag_key DataAwsCeTags#tag_key}
    */
    readonly tagKey?: string;
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#filter DataAwsCeTags#filter}
    */
    readonly filter?: DataAwsCeTagsFilter;
    /**
    * sort_by block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#sort_by DataAwsCeTags#sort_by}
    */
    readonly sortBy?: DataAwsCeTagsSortBy[] | cdktf.IResolvable;
    /**
    * time_period block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#time_period DataAwsCeTags#time_period}
    */
    readonly timePeriod: DataAwsCeTagsTimePeriod;
}
export interface DataAwsCeTagsFilterAndCostCategory {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#key DataAwsCeTags#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#match_options DataAwsCeTags#match_options}
    */
    readonly matchOptions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#values DataAwsCeTags#values}
    */
    readonly values?: string[];
}
export declare function dataAwsCeTagsFilterAndCostCategoryToTerraform(struct?: DataAwsCeTagsFilterAndCostCategoryOutputReference | DataAwsCeTagsFilterAndCostCategory): any;
export declare class DataAwsCeTagsFilterAndCostCategoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAwsCeTagsFilterAndCostCategory | undefined;
    set internalValue(value: DataAwsCeTagsFilterAndCostCategory | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _matchOptions?;
    get matchOptions(): string[];
    set matchOptions(value: string[]);
    resetMatchOptions(): void;
    get matchOptionsInput(): string[] | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface DataAwsCeTagsFilterAndDimension {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#key DataAwsCeTags#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#match_options DataAwsCeTags#match_options}
    */
    readonly matchOptions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#values DataAwsCeTags#values}
    */
    readonly values?: string[];
}
export declare function dataAwsCeTagsFilterAndDimensionToTerraform(struct?: DataAwsCeTagsFilterAndDimensionOutputReference | DataAwsCeTagsFilterAndDimension): any;
export declare class DataAwsCeTagsFilterAndDimensionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAwsCeTagsFilterAndDimension | undefined;
    set internalValue(value: DataAwsCeTagsFilterAndDimension | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _matchOptions?;
    get matchOptions(): string[];
    set matchOptions(value: string[]);
    resetMatchOptions(): void;
    get matchOptionsInput(): string[] | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface DataAwsCeTagsFilterAndTags {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#key DataAwsCeTags#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#match_options DataAwsCeTags#match_options}
    */
    readonly matchOptions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#values DataAwsCeTags#values}
    */
    readonly values?: string[];
}
export declare function dataAwsCeTagsFilterAndTagsToTerraform(struct?: DataAwsCeTagsFilterAndTagsOutputReference | DataAwsCeTagsFilterAndTags): any;
export declare class DataAwsCeTagsFilterAndTagsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAwsCeTagsFilterAndTags | undefined;
    set internalValue(value: DataAwsCeTagsFilterAndTags | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _matchOptions?;
    get matchOptions(): string[];
    set matchOptions(value: string[]);
    resetMatchOptions(): void;
    get matchOptionsInput(): string[] | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface DataAwsCeTagsFilterAnd {
    /**
    * cost_category block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#cost_category DataAwsCeTags#cost_category}
    */
    readonly costCategory?: DataAwsCeTagsFilterAndCostCategory;
    /**
    * dimension block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#dimension DataAwsCeTags#dimension}
    */
    readonly dimension?: DataAwsCeTagsFilterAndDimension;
    /**
    * tags block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#tags DataAwsCeTags#tags}
    */
    readonly tags?: DataAwsCeTagsFilterAndTags;
}
export declare function dataAwsCeTagsFilterAndToTerraform(struct?: DataAwsCeTagsFilterAnd | cdktf.IResolvable): any;
export interface DataAwsCeTagsFilterCostCategory {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#key DataAwsCeTags#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#match_options DataAwsCeTags#match_options}
    */
    readonly matchOptions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#values DataAwsCeTags#values}
    */
    readonly values?: string[];
}
export declare function dataAwsCeTagsFilterCostCategoryToTerraform(struct?: DataAwsCeTagsFilterCostCategoryOutputReference | DataAwsCeTagsFilterCostCategory): any;
export declare class DataAwsCeTagsFilterCostCategoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAwsCeTagsFilterCostCategory | undefined;
    set internalValue(value: DataAwsCeTagsFilterCostCategory | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _matchOptions?;
    get matchOptions(): string[];
    set matchOptions(value: string[]);
    resetMatchOptions(): void;
    get matchOptionsInput(): string[] | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface DataAwsCeTagsFilterDimension {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#key DataAwsCeTags#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#match_options DataAwsCeTags#match_options}
    */
    readonly matchOptions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#values DataAwsCeTags#values}
    */
    readonly values?: string[];
}
export declare function dataAwsCeTagsFilterDimensionToTerraform(struct?: DataAwsCeTagsFilterDimensionOutputReference | DataAwsCeTagsFilterDimension): any;
export declare class DataAwsCeTagsFilterDimensionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAwsCeTagsFilterDimension | undefined;
    set internalValue(value: DataAwsCeTagsFilterDimension | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _matchOptions?;
    get matchOptions(): string[];
    set matchOptions(value: string[]);
    resetMatchOptions(): void;
    get matchOptionsInput(): string[] | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface DataAwsCeTagsFilterNotCostCategory {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#key DataAwsCeTags#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#match_options DataAwsCeTags#match_options}
    */
    readonly matchOptions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#values DataAwsCeTags#values}
    */
    readonly values?: string[];
}
export declare function dataAwsCeTagsFilterNotCostCategoryToTerraform(struct?: DataAwsCeTagsFilterNotCostCategoryOutputReference | DataAwsCeTagsFilterNotCostCategory): any;
export declare class DataAwsCeTagsFilterNotCostCategoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAwsCeTagsFilterNotCostCategory | undefined;
    set internalValue(value: DataAwsCeTagsFilterNotCostCategory | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _matchOptions?;
    get matchOptions(): string[];
    set matchOptions(value: string[]);
    resetMatchOptions(): void;
    get matchOptionsInput(): string[] | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface DataAwsCeTagsFilterNotDimension {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#key DataAwsCeTags#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#match_options DataAwsCeTags#match_options}
    */
    readonly matchOptions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#values DataAwsCeTags#values}
    */
    readonly values?: string[];
}
export declare function dataAwsCeTagsFilterNotDimensionToTerraform(struct?: DataAwsCeTagsFilterNotDimensionOutputReference | DataAwsCeTagsFilterNotDimension): any;
export declare class DataAwsCeTagsFilterNotDimensionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAwsCeTagsFilterNotDimension | undefined;
    set internalValue(value: DataAwsCeTagsFilterNotDimension | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _matchOptions?;
    get matchOptions(): string[];
    set matchOptions(value: string[]);
    resetMatchOptions(): void;
    get matchOptionsInput(): string[] | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface DataAwsCeTagsFilterNotTags {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#key DataAwsCeTags#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#match_options DataAwsCeTags#match_options}
    */
    readonly matchOptions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#values DataAwsCeTags#values}
    */
    readonly values?: string[];
}
export declare function dataAwsCeTagsFilterNotTagsToTerraform(struct?: DataAwsCeTagsFilterNotTagsOutputReference | DataAwsCeTagsFilterNotTags): any;
export declare class DataAwsCeTagsFilterNotTagsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAwsCeTagsFilterNotTags | undefined;
    set internalValue(value: DataAwsCeTagsFilterNotTags | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _matchOptions?;
    get matchOptions(): string[];
    set matchOptions(value: string[]);
    resetMatchOptions(): void;
    get matchOptionsInput(): string[] | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface DataAwsCeTagsFilterNot {
    /**
    * cost_category block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#cost_category DataAwsCeTags#cost_category}
    */
    readonly costCategory?: DataAwsCeTagsFilterNotCostCategory;
    /**
    * dimension block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#dimension DataAwsCeTags#dimension}
    */
    readonly dimension?: DataAwsCeTagsFilterNotDimension;
    /**
    * tags block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#tags DataAwsCeTags#tags}
    */
    readonly tags?: DataAwsCeTagsFilterNotTags;
}
export declare function dataAwsCeTagsFilterNotToTerraform(struct?: DataAwsCeTagsFilterNotOutputReference | DataAwsCeTagsFilterNot): any;
export declare class DataAwsCeTagsFilterNotOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAwsCeTagsFilterNot | undefined;
    set internalValue(value: DataAwsCeTagsFilterNot | undefined);
    private _costCategory;
    get costCategory(): DataAwsCeTagsFilterNotCostCategoryOutputReference;
    putCostCategory(value: DataAwsCeTagsFilterNotCostCategory): void;
    resetCostCategory(): void;
    get costCategoryInput(): DataAwsCeTagsFilterNotCostCategory | undefined;
    private _dimension;
    get dimension(): DataAwsCeTagsFilterNotDimensionOutputReference;
    putDimension(value: DataAwsCeTagsFilterNotDimension): void;
    resetDimension(): void;
    get dimensionInput(): DataAwsCeTagsFilterNotDimension | undefined;
    private _tags;
    get tags(): DataAwsCeTagsFilterNotTagsOutputReference;
    putTags(value: DataAwsCeTagsFilterNotTags): void;
    resetTags(): void;
    get tagsInput(): DataAwsCeTagsFilterNotTags | undefined;
}
export interface DataAwsCeTagsFilterOrCostCategory {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#key DataAwsCeTags#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#match_options DataAwsCeTags#match_options}
    */
    readonly matchOptions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#values DataAwsCeTags#values}
    */
    readonly values?: string[];
}
export declare function dataAwsCeTagsFilterOrCostCategoryToTerraform(struct?: DataAwsCeTagsFilterOrCostCategoryOutputReference | DataAwsCeTagsFilterOrCostCategory): any;
export declare class DataAwsCeTagsFilterOrCostCategoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAwsCeTagsFilterOrCostCategory | undefined;
    set internalValue(value: DataAwsCeTagsFilterOrCostCategory | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _matchOptions?;
    get matchOptions(): string[];
    set matchOptions(value: string[]);
    resetMatchOptions(): void;
    get matchOptionsInput(): string[] | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface DataAwsCeTagsFilterOrDimension {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#key DataAwsCeTags#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#match_options DataAwsCeTags#match_options}
    */
    readonly matchOptions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#values DataAwsCeTags#values}
    */
    readonly values?: string[];
}
export declare function dataAwsCeTagsFilterOrDimensionToTerraform(struct?: DataAwsCeTagsFilterOrDimensionOutputReference | DataAwsCeTagsFilterOrDimension): any;
export declare class DataAwsCeTagsFilterOrDimensionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAwsCeTagsFilterOrDimension | undefined;
    set internalValue(value: DataAwsCeTagsFilterOrDimension | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _matchOptions?;
    get matchOptions(): string[];
    set matchOptions(value: string[]);
    resetMatchOptions(): void;
    get matchOptionsInput(): string[] | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface DataAwsCeTagsFilterOrTags {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#key DataAwsCeTags#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#match_options DataAwsCeTags#match_options}
    */
    readonly matchOptions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#values DataAwsCeTags#values}
    */
    readonly values?: string[];
}
export declare function dataAwsCeTagsFilterOrTagsToTerraform(struct?: DataAwsCeTagsFilterOrTagsOutputReference | DataAwsCeTagsFilterOrTags): any;
export declare class DataAwsCeTagsFilterOrTagsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAwsCeTagsFilterOrTags | undefined;
    set internalValue(value: DataAwsCeTagsFilterOrTags | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _matchOptions?;
    get matchOptions(): string[];
    set matchOptions(value: string[]);
    resetMatchOptions(): void;
    get matchOptionsInput(): string[] | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface DataAwsCeTagsFilterOr {
    /**
    * cost_category block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#cost_category DataAwsCeTags#cost_category}
    */
    readonly costCategory?: DataAwsCeTagsFilterOrCostCategory;
    /**
    * dimension block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#dimension DataAwsCeTags#dimension}
    */
    readonly dimension?: DataAwsCeTagsFilterOrDimension;
    /**
    * tags block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#tags DataAwsCeTags#tags}
    */
    readonly tags?: DataAwsCeTagsFilterOrTags;
}
export declare function dataAwsCeTagsFilterOrToTerraform(struct?: DataAwsCeTagsFilterOr | cdktf.IResolvable): any;
export interface DataAwsCeTagsFilterTags {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#key DataAwsCeTags#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#match_options DataAwsCeTags#match_options}
    */
    readonly matchOptions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#values DataAwsCeTags#values}
    */
    readonly values?: string[];
}
export declare function dataAwsCeTagsFilterTagsToTerraform(struct?: DataAwsCeTagsFilterTagsOutputReference | DataAwsCeTagsFilterTags): any;
export declare class DataAwsCeTagsFilterTagsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAwsCeTagsFilterTags | undefined;
    set internalValue(value: DataAwsCeTagsFilterTags | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _matchOptions?;
    get matchOptions(): string[];
    set matchOptions(value: string[]);
    resetMatchOptions(): void;
    get matchOptionsInput(): string[] | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface DataAwsCeTagsFilter {
    /**
    * and block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#and DataAwsCeTags#and}
    */
    readonly and?: DataAwsCeTagsFilterAnd[] | cdktf.IResolvable;
    /**
    * cost_category block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#cost_category DataAwsCeTags#cost_category}
    */
    readonly costCategory?: DataAwsCeTagsFilterCostCategory;
    /**
    * dimension block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#dimension DataAwsCeTags#dimension}
    */
    readonly dimension?: DataAwsCeTagsFilterDimension;
    /**
    * not block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#not DataAwsCeTags#not}
    */
    readonly not?: DataAwsCeTagsFilterNot;
    /**
    * or block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#or DataAwsCeTags#or}
    */
    readonly or?: DataAwsCeTagsFilterOr[] | cdktf.IResolvable;
    /**
    * tags block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#tags DataAwsCeTags#tags}
    */
    readonly tags?: DataAwsCeTagsFilterTags;
}
export declare function dataAwsCeTagsFilterToTerraform(struct?: DataAwsCeTagsFilterOutputReference | DataAwsCeTagsFilter): any;
export declare class DataAwsCeTagsFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAwsCeTagsFilter | undefined;
    set internalValue(value: DataAwsCeTagsFilter | undefined);
    private _and?;
    get and(): DataAwsCeTagsFilterAnd[] | cdktf.IResolvable;
    set and(value: DataAwsCeTagsFilterAnd[] | cdktf.IResolvable);
    resetAnd(): void;
    get andInput(): cdktf.IResolvable | DataAwsCeTagsFilterAnd[] | undefined;
    private _costCategory;
    get costCategory(): DataAwsCeTagsFilterCostCategoryOutputReference;
    putCostCategory(value: DataAwsCeTagsFilterCostCategory): void;
    resetCostCategory(): void;
    get costCategoryInput(): DataAwsCeTagsFilterCostCategory | undefined;
    private _dimension;
    get dimension(): DataAwsCeTagsFilterDimensionOutputReference;
    putDimension(value: DataAwsCeTagsFilterDimension): void;
    resetDimension(): void;
    get dimensionInput(): DataAwsCeTagsFilterDimension | undefined;
    private _not;
    get not(): DataAwsCeTagsFilterNotOutputReference;
    putNot(value: DataAwsCeTagsFilterNot): void;
    resetNot(): void;
    get notInput(): DataAwsCeTagsFilterNot | undefined;
    private _or?;
    get or(): DataAwsCeTagsFilterOr[] | cdktf.IResolvable;
    set or(value: DataAwsCeTagsFilterOr[] | cdktf.IResolvable);
    resetOr(): void;
    get orInput(): cdktf.IResolvable | DataAwsCeTagsFilterOr[] | undefined;
    private _tags;
    get tags(): DataAwsCeTagsFilterTagsOutputReference;
    putTags(value: DataAwsCeTagsFilterTags): void;
    resetTags(): void;
    get tagsInput(): DataAwsCeTagsFilterTags | undefined;
}
export interface DataAwsCeTagsSortBy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#key DataAwsCeTags#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#sort_order DataAwsCeTags#sort_order}
    */
    readonly sortOrder?: string;
}
export declare function dataAwsCeTagsSortByToTerraform(struct?: DataAwsCeTagsSortBy | cdktf.IResolvable): any;
export interface DataAwsCeTagsTimePeriod {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#end DataAwsCeTags#end}
    */
    readonly end: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ce_tags#start DataAwsCeTags#start}
    */
    readonly start: string;
}
export declare function dataAwsCeTagsTimePeriodToTerraform(struct?: DataAwsCeTagsTimePeriodOutputReference | DataAwsCeTagsTimePeriod): any;
export declare class DataAwsCeTagsTimePeriodOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAwsCeTagsTimePeriod | undefined;
    set internalValue(value: DataAwsCeTagsTimePeriod | undefined);
    private _end?;
    get end(): string;
    set end(value: string);
    get endInput(): string | undefined;
    private _start?;
    get start(): string;
    set start(value: string);
    get startInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/ce_tags aws_ce_tags}
*/
export declare class DataAwsCeTags extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_ce_tags";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/ce_tags aws_ce_tags} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsCeTagsConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsCeTagsConfig);
    get id(): string;
    private _searchString?;
    get searchString(): string;
    set searchString(value: string);
    resetSearchString(): void;
    get searchStringInput(): string | undefined;
    private _tagKey?;
    get tagKey(): string;
    set tagKey(value: string);
    resetTagKey(): void;
    get tagKeyInput(): string | undefined;
    get tags(): string[];
    private _filter;
    get filter(): DataAwsCeTagsFilterOutputReference;
    putFilter(value: DataAwsCeTagsFilter): void;
    resetFilter(): void;
    get filterInput(): DataAwsCeTagsFilter | undefined;
    private _sortBy?;
    get sortBy(): DataAwsCeTagsSortBy[] | cdktf.IResolvable;
    set sortBy(value: DataAwsCeTagsSortBy[] | cdktf.IResolvable);
    resetSortBy(): void;
    get sortByInput(): cdktf.IResolvable | DataAwsCeTagsSortBy[] | undefined;
    private _timePeriod;
    get timePeriod(): DataAwsCeTagsTimePeriodOutputReference;
    putTimePeriod(value: DataAwsCeTagsTimePeriod): void;
    get timePeriodInput(): DataAwsCeTagsTimePeriod | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-ce-tags.d.ts.map