import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAwsGrafanaWorkspaceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/grafana_workspace#tags DataAwsGrafanaWorkspace#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/grafana_workspace#workspace_id DataAwsGrafanaWorkspace#workspace_id}
    */
    readonly workspaceId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/grafana_workspace aws_grafana_workspace}
*/
export declare class DataAwsGrafanaWorkspace extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_grafana_workspace";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/grafana_workspace aws_grafana_workspace} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsGrafanaWorkspaceConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsGrafanaWorkspaceConfig);
    get accountAccessType(): string;
    get arn(): string;
    get authenticationProviders(): string[];
    get createdDate(): string;
    get dataSources(): string[];
    get description(): string;
    get endpoint(): string;
    get grafanaVersion(): string;
    get id(): string;
    get lastUpdatedDate(): string;
    get name(): string;
    get notificationDestinations(): string[];
    get organizationRoleName(): string;
    get organizationalUnits(): string[];
    get permissionType(): string;
    get roleArn(): string;
    get samlConfigurationStatus(): string;
    get stackSetName(): string;
    get status(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _workspaceId?;
    get workspaceId(): string;
    set workspaceId(value: string);
    get workspaceIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-grafana-workspace.d.ts.map