import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAwsLocationMapConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/location_map#map_name DataAwsLocationMap#map_name}
    */
    readonly mapName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/location_map#tags DataAwsLocationMap#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
}
export interface DataAwsLocationMapConfiguration {
}
export declare function dataAwsLocationMapConfigurationToTerraform(struct?: DataAwsLocationMapConfiguration): any;
export declare class DataAwsLocationMapConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsLocationMapConfiguration | undefined;
    set internalValue(value: DataAwsLocationMapConfiguration | undefined);
    get style(): string;
}
export declare class DataAwsLocationMapConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsLocationMapConfigurationOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/location_map aws_location_map}
*/
export declare class DataAwsLocationMap extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_location_map";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/location_map aws_location_map} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsLocationMapConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsLocationMapConfig);
    private _configuration;
    get configuration(): DataAwsLocationMapConfigurationList;
    get createTime(): string;
    get description(): string;
    get id(): string;
    get mapArn(): string;
    private _mapName?;
    get mapName(): string;
    set mapName(value: string);
    get mapNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get updateTime(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-location-map.d.ts.map