import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAwsMemorydbAclConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/memorydb_acl#name DataAwsMemorydbAcl#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/memorydb_acl#tags DataAwsMemorydbAcl#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/memorydb_acl aws_memorydb_acl}
*/
export declare class DataAwsMemorydbAcl extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_memorydb_acl";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/memorydb_acl aws_memorydb_acl} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsMemorydbAclConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsMemorydbAclConfig);
    get arn(): string;
    get id(): string;
    get minimumEngineVersion(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get userNames(): string[];
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-memorydb-acl.d.ts.map