import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAwsMemorydbParameterGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/memorydb_parameter_group#name DataAwsMemorydbParameterGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/memorydb_parameter_group#tags DataAwsMemorydbParameterGroup#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
}
export interface DataAwsMemorydbParameterGroupParameter {
}
export declare function dataAwsMemorydbParameterGroupParameterToTerraform(struct?: DataAwsMemorydbParameterGroupParameter): any;
export declare class DataAwsMemorydbParameterGroupParameterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsMemorydbParameterGroupParameter | undefined;
    set internalValue(value: DataAwsMemorydbParameterGroupParameter | undefined);
    get name(): string;
    get value(): string;
}
export declare class DataAwsMemorydbParameterGroupParameterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsMemorydbParameterGroupParameterOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/memorydb_parameter_group aws_memorydb_parameter_group}
*/
export declare class DataAwsMemorydbParameterGroup extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_memorydb_parameter_group";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/memorydb_parameter_group aws_memorydb_parameter_group} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsMemorydbParameterGroupConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsMemorydbParameterGroupConfig);
    get arn(): string;
    get description(): string;
    get family(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameter;
    get parameter(): DataAwsMemorydbParameterGroupParameterList;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-memorydb-parameter-group.d.ts.map