import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAwsMemorydbUserConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/memorydb_user#tags DataAwsMemorydbUser#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/memorydb_user#user_name DataAwsMemorydbUser#user_name}
    */
    readonly userName: string;
}
export interface DataAwsMemorydbUserAuthenticationMode {
}
export declare function dataAwsMemorydbUserAuthenticationModeToTerraform(struct?: DataAwsMemorydbUserAuthenticationMode): any;
export declare class DataAwsMemorydbUserAuthenticationModeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsMemorydbUserAuthenticationMode | undefined;
    set internalValue(value: DataAwsMemorydbUserAuthenticationMode | undefined);
    get passwordCount(): number;
    get type(): string;
}
export declare class DataAwsMemorydbUserAuthenticationModeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsMemorydbUserAuthenticationModeOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/memorydb_user aws_memorydb_user}
*/
export declare class DataAwsMemorydbUser extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_memorydb_user";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/memorydb_user aws_memorydb_user} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsMemorydbUserConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsMemorydbUserConfig);
    get accessString(): string;
    get arn(): string;
    private _authenticationMode;
    get authenticationMode(): DataAwsMemorydbUserAuthenticationModeList;
    get id(): string;
    get minimumEngineVersion(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _userName?;
    get userName(): string;
    set userName(value: string);
    get userNameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-memorydb-user.d.ts.map