import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAwsServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/service#dns_name DataAwsService#dns_name}
    */
    readonly dnsName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/service#region DataAwsService#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/service#reverse_dns_name DataAwsService#reverse_dns_name}
    */
    readonly reverseDnsName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/service#reverse_dns_prefix DataAwsService#reverse_dns_prefix}
    */
    readonly reverseDnsPrefix?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/service#service_id DataAwsService#service_id}
    */
    readonly serviceId?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/service aws_service}
*/
export declare class DataAwsService extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_service";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/service aws_service} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsServiceConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAwsServiceConfig);
    private _dnsName?;
    get dnsName(): string;
    set dnsName(value: string);
    resetDnsName(): void;
    get dnsNameInput(): string | undefined;
    get id(): string;
    get partition(): string;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _reverseDnsName?;
    get reverseDnsName(): string;
    set reverseDnsName(value: string);
    resetReverseDnsName(): void;
    get reverseDnsNameInput(): string | undefined;
    private _reverseDnsPrefix?;
    get reverseDnsPrefix(): string;
    set reverseDnsPrefix(value: string);
    resetReverseDnsPrefix(): void;
    get reverseDnsPrefixInput(): string | undefined;
    private _serviceId?;
    get serviceId(): string;
    set serviceId(value: string);
    resetServiceId(): void;
    get serviceIdInput(): string | undefined;
    get supported(): cdktf.IResolvable;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-service.d.ts.map