import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Data Pipeline
*/
export interface DataAwsDatapipelinePipelineConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/datapipeline_pipeline#pipeline_id DataAwsDatapipelinePipeline#pipeline_id}
    */
    readonly pipelineId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/datapipeline_pipeline#tags DataAwsDatapipelinePipeline#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/datapipeline_pipeline aws_datapipeline_pipeline}
*/
export declare class DataAwsDatapipelinePipeline extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_datapipeline_pipeline";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/datapipeline_pipeline aws_datapipeline_pipeline} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsDatapipelinePipelineConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsDatapipelinePipelineConfig);
    get description(): string;
    get id(): string;
    get name(): string;
    private _pipelineId?;
    get pipelineId(): string;
    set pipelineId(value: string);
    get pipelineIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-datapipeline-pipeline.d.ts.map