import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Data Pipeline
*/
export interface DatapipelinePipelineDefinitionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/datapipeline_pipeline_definition#pipeline_id DatapipelinePipelineDefinition#pipeline_id}
    */
    readonly pipelineId: string;
    /**
    * parameter_object block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/datapipeline_pipeline_definition#parameter_object DatapipelinePipelineDefinition#parameter_object}
    */
    readonly parameterObject?: DatapipelinePipelineDefinitionParameterObject[] | cdktf.IResolvable;
    /**
    * parameter_value block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/datapipeline_pipeline_definition#parameter_value DatapipelinePipelineDefinition#parameter_value}
    */
    readonly parameterValue?: DatapipelinePipelineDefinitionParameterValue[] | cdktf.IResolvable;
    /**
    * pipeline_object block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/datapipeline_pipeline_definition#pipeline_object DatapipelinePipelineDefinition#pipeline_object}
    */
    readonly pipelineObject: DatapipelinePipelineDefinitionPipelineObject[] | cdktf.IResolvable;
}
export interface DatapipelinePipelineDefinitionParameterObjectAttribute {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/datapipeline_pipeline_definition#key DatapipelinePipelineDefinition#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/datapipeline_pipeline_definition#string_value DatapipelinePipelineDefinition#string_value}
    */
    readonly stringValue: string;
}
export declare function datapipelinePipelineDefinitionParameterObjectAttributeToTerraform(struct?: DatapipelinePipelineDefinitionParameterObjectAttribute | cdktf.IResolvable): any;
export interface DatapipelinePipelineDefinitionParameterObject {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/datapipeline_pipeline_definition#id DatapipelinePipelineDefinition#id}
    */
    readonly id: string;
    /**
    * attribute block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/datapipeline_pipeline_definition#attribute DatapipelinePipelineDefinition#attribute}
    */
    readonly attribute?: DatapipelinePipelineDefinitionParameterObjectAttribute[] | cdktf.IResolvable;
}
export declare function datapipelinePipelineDefinitionParameterObjectToTerraform(struct?: DatapipelinePipelineDefinitionParameterObject | cdktf.IResolvable): any;
export interface DatapipelinePipelineDefinitionParameterValue {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/datapipeline_pipeline_definition#id DatapipelinePipelineDefinition#id}
    */
    readonly id: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/datapipeline_pipeline_definition#string_value DatapipelinePipelineDefinition#string_value}
    */
    readonly stringValue: string;
}
export declare function datapipelinePipelineDefinitionParameterValueToTerraform(struct?: DatapipelinePipelineDefinitionParameterValue | cdktf.IResolvable): any;
export interface DatapipelinePipelineDefinitionPipelineObjectField {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/datapipeline_pipeline_definition#key DatapipelinePipelineDefinition#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/datapipeline_pipeline_definition#ref_value DatapipelinePipelineDefinition#ref_value}
    */
    readonly refValue?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/datapipeline_pipeline_definition#string_value DatapipelinePipelineDefinition#string_value}
    */
    readonly stringValue?: string;
}
export declare function datapipelinePipelineDefinitionPipelineObjectFieldToTerraform(struct?: DatapipelinePipelineDefinitionPipelineObjectField | cdktf.IResolvable): any;
export interface DatapipelinePipelineDefinitionPipelineObject {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/datapipeline_pipeline_definition#id DatapipelinePipelineDefinition#id}
    */
    readonly id: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/datapipeline_pipeline_definition#name DatapipelinePipelineDefinition#name}
    */
    readonly name: string;
    /**
    * field block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/datapipeline_pipeline_definition#field DatapipelinePipelineDefinition#field}
    */
    readonly field?: DatapipelinePipelineDefinitionPipelineObjectField[] | cdktf.IResolvable;
}
export declare function datapipelinePipelineDefinitionPipelineObjectToTerraform(struct?: DatapipelinePipelineDefinitionPipelineObject | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/datapipeline_pipeline_definition aws_datapipeline_pipeline_definition}
*/
export declare class DatapipelinePipelineDefinition extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_datapipeline_pipeline_definition";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/datapipeline_pipeline_definition aws_datapipeline_pipeline_definition} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DatapipelinePipelineDefinitionConfig
    */
    constructor(scope: Construct, id: string, config: DatapipelinePipelineDefinitionConfig);
    get id(): string;
    private _pipelineId?;
    get pipelineId(): string;
    set pipelineId(value: string);
    get pipelineIdInput(): string | undefined;
    private _parameterObject?;
    get parameterObject(): DatapipelinePipelineDefinitionParameterObject[] | cdktf.IResolvable;
    set parameterObject(value: DatapipelinePipelineDefinitionParameterObject[] | cdktf.IResolvable);
    resetParameterObject(): void;
    get parameterObjectInput(): cdktf.IResolvable | DatapipelinePipelineDefinitionParameterObject[] | undefined;
    private _parameterValue?;
    get parameterValue(): DatapipelinePipelineDefinitionParameterValue[] | cdktf.IResolvable;
    set parameterValue(value: DatapipelinePipelineDefinitionParameterValue[] | cdktf.IResolvable);
    resetParameterValue(): void;
    get parameterValueInput(): cdktf.IResolvable | DatapipelinePipelineDefinitionParameterValue[] | undefined;
    private _pipelineObject?;
    get pipelineObject(): DatapipelinePipelineDefinitionPipelineObject[] | cdktf.IResolvable;
    set pipelineObject(value: DatapipelinePipelineDefinitionPipelineObject[] | cdktf.IResolvable);
    get pipelineObjectInput(): cdktf.IResolvable | DatapipelinePipelineDefinitionPipelineObject[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=datapipeline-pipeline-definition.d.ts.map