"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DatapipelinePipelineDefinition = exports.datapipelinePipelineDefinitionPipelineObjectToTerraform = exports.datapipelinePipelineDefinitionPipelineObjectFieldToTerraform = exports.datapipelinePipelineDefinitionParameterValueToTerraform = exports.datapipelinePipelineDefinitionParameterObjectToTerraform = exports.datapipelinePipelineDefinitionParameterObjectAttributeToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function datapipelinePipelineDefinitionParameterObjectAttributeToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        key: cdktf.stringToTerraform(struct.key),
        string_value: cdktf.stringToTerraform(struct.stringValue),
    };
}
exports.datapipelinePipelineDefinitionParameterObjectAttributeToTerraform = datapipelinePipelineDefinitionParameterObjectAttributeToTerraform;
function datapipelinePipelineDefinitionParameterObjectToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        id: cdktf.stringToTerraform(struct.id),
        attribute: cdktf.listMapper(datapipelinePipelineDefinitionParameterObjectAttributeToTerraform)(struct.attribute),
    };
}
exports.datapipelinePipelineDefinitionParameterObjectToTerraform = datapipelinePipelineDefinitionParameterObjectToTerraform;
function datapipelinePipelineDefinitionParameterValueToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        id: cdktf.stringToTerraform(struct.id),
        string_value: cdktf.stringToTerraform(struct.stringValue),
    };
}
exports.datapipelinePipelineDefinitionParameterValueToTerraform = datapipelinePipelineDefinitionParameterValueToTerraform;
function datapipelinePipelineDefinitionPipelineObjectFieldToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        key: cdktf.stringToTerraform(struct.key),
        ref_value: cdktf.stringToTerraform(struct.refValue),
        string_value: cdktf.stringToTerraform(struct.stringValue),
    };
}
exports.datapipelinePipelineDefinitionPipelineObjectFieldToTerraform = datapipelinePipelineDefinitionPipelineObjectFieldToTerraform;
function datapipelinePipelineDefinitionPipelineObjectToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        id: cdktf.stringToTerraform(struct.id),
        name: cdktf.stringToTerraform(struct.name),
        field: cdktf.listMapper(datapipelinePipelineDefinitionPipelineObjectFieldToTerraform)(struct.field),
    };
}
exports.datapipelinePipelineDefinitionPipelineObjectToTerraform = datapipelinePipelineDefinitionPipelineObjectToTerraform;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/datapipeline_pipeline_definition aws_datapipeline_pipeline_definition}
*/
class DatapipelinePipelineDefinition extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/datapipeline_pipeline_definition aws_datapipeline_pipeline_definition} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DatapipelinePipelineDefinitionConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_datapipeline_pipeline_definition',
            terraformGeneratorMetadata: {
                providerName: 'aws',
                providerVersion: '4.15.1',
                providerVersionConstraint: '~> 4.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._pipelineId = config.pipelineId;
        this._parameterObject = config.parameterObject;
        this._parameterValue = config.parameterValue;
        this._pipelineObject = config.pipelineObject;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get pipelineId() {
        return this.getStringAttribute('pipeline_id');
    }
    set pipelineId(value) {
        this._pipelineId = value;
    }
    // Temporarily expose input value. Use with caution.
    get pipelineIdInput() {
        return this._pipelineId;
    }
    get parameterObject() {
        // Getting the computed value is not yet implemented
        return cdktf.Token.asAny(cdktf.Fn.tolist(this.interpolationForAttribute('parameter_object')));
    }
    set parameterObject(value) {
        this._parameterObject = value;
    }
    resetParameterObject() {
        this._parameterObject = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get parameterObjectInput() {
        return this._parameterObject;
    }
    get parameterValue() {
        // Getting the computed value is not yet implemented
        return cdktf.Token.asAny(cdktf.Fn.tolist(this.interpolationForAttribute('parameter_value')));
    }
    set parameterValue(value) {
        this._parameterValue = value;
    }
    resetParameterValue() {
        this._parameterValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get parameterValueInput() {
        return this._parameterValue;
    }
    get pipelineObject() {
        // Getting the computed value is not yet implemented
        return cdktf.Token.asAny(cdktf.Fn.tolist(this.interpolationForAttribute('pipeline_object')));
    }
    set pipelineObject(value) {
        this._pipelineObject = value;
    }
    // Temporarily expose input value. Use with caution.
    get pipelineObjectInput() {
        return this._pipelineObject;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            pipeline_id: cdktf.stringToTerraform(this._pipelineId),
            parameter_object: cdktf.listMapper(datapipelinePipelineDefinitionParameterObjectToTerraform)(this._parameterObject),
            parameter_value: cdktf.listMapper(datapipelinePipelineDefinitionParameterValueToTerraform)(this._parameterValue),
            pipeline_object: cdktf.listMapper(datapipelinePipelineDefinitionPipelineObjectToTerraform)(this._pipelineObject),
        };
    }
}
exports.DatapipelinePipelineDefinition = DatapipelinePipelineDefinition;
_a = JSII_RTTI_SYMBOL_1;
DatapipelinePipelineDefinition[_a] = { fqn: "@cdktf/provider-aws.datapipeline.DatapipelinePipelineDefinition", version: "7.0.64" };
// =================
// STATIC PROPERTIES
// =================
DatapipelinePipelineDefinition.tfResourceType = "aws_datapipeline_pipeline_definition";
//# sourceMappingURL=data:application/json;base64,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