import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Data Sources
*/
export interface DataAwsLaunchConfigurationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/launch_configuration#name DataAwsLaunchConfiguration#name}
    */
    readonly name: string;
}
export interface DataAwsLaunchConfigurationEbsBlockDevice {
}
export declare function dataAwsLaunchConfigurationEbsBlockDeviceToTerraform(struct?: DataAwsLaunchConfigurationEbsBlockDevice): any;
export declare class DataAwsLaunchConfigurationEbsBlockDeviceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsLaunchConfigurationEbsBlockDevice | undefined;
    set internalValue(value: DataAwsLaunchConfigurationEbsBlockDevice | undefined);
    get deleteOnTermination(): cdktf.IResolvable;
    get deviceName(): string;
    get encrypted(): cdktf.IResolvable;
    get iops(): number;
    get noDevice(): cdktf.IResolvable;
    get snapshotId(): string;
    get throughput(): cdktf.IResolvable;
    get volumeSize(): number;
    get volumeType(): string;
}
export declare class DataAwsLaunchConfigurationEbsBlockDeviceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsLaunchConfigurationEbsBlockDeviceOutputReference;
}
export interface DataAwsLaunchConfigurationEphemeralBlockDevice {
}
export declare function dataAwsLaunchConfigurationEphemeralBlockDeviceToTerraform(struct?: DataAwsLaunchConfigurationEphemeralBlockDevice): any;
export declare class DataAwsLaunchConfigurationEphemeralBlockDeviceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsLaunchConfigurationEphemeralBlockDevice | undefined;
    set internalValue(value: DataAwsLaunchConfigurationEphemeralBlockDevice | undefined);
    get deviceName(): string;
    get virtualName(): string;
}
export declare class DataAwsLaunchConfigurationEphemeralBlockDeviceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsLaunchConfigurationEphemeralBlockDeviceOutputReference;
}
export interface DataAwsLaunchConfigurationMetadataOptions {
}
export declare function dataAwsLaunchConfigurationMetadataOptionsToTerraform(struct?: DataAwsLaunchConfigurationMetadataOptions): any;
export declare class DataAwsLaunchConfigurationMetadataOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsLaunchConfigurationMetadataOptions | undefined;
    set internalValue(value: DataAwsLaunchConfigurationMetadataOptions | undefined);
    get httpEndpoint(): string;
    get httpPutResponseHopLimit(): number;
    get httpTokens(): string;
}
export declare class DataAwsLaunchConfigurationMetadataOptionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsLaunchConfigurationMetadataOptionsOutputReference;
}
export interface DataAwsLaunchConfigurationRootBlockDevice {
}
export declare function dataAwsLaunchConfigurationRootBlockDeviceToTerraform(struct?: DataAwsLaunchConfigurationRootBlockDevice): any;
export declare class DataAwsLaunchConfigurationRootBlockDeviceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsLaunchConfigurationRootBlockDevice | undefined;
    set internalValue(value: DataAwsLaunchConfigurationRootBlockDevice | undefined);
    get deleteOnTermination(): cdktf.IResolvable;
    get encrypted(): cdktf.IResolvable;
    get iops(): number;
    get throughput(): cdktf.IResolvable;
    get volumeSize(): number;
    get volumeType(): string;
}
export declare class DataAwsLaunchConfigurationRootBlockDeviceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsLaunchConfigurationRootBlockDeviceOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/launch_configuration aws_launch_configuration}
*/
export declare class DataAwsLaunchConfiguration extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_launch_configuration";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/launch_configuration aws_launch_configuration} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsLaunchConfigurationConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsLaunchConfigurationConfig);
    get arn(): string;
    get associatePublicIpAddress(): cdktf.IResolvable;
    private _ebsBlockDevice;
    get ebsBlockDevice(): DataAwsLaunchConfigurationEbsBlockDeviceList;
    get ebsOptimized(): cdktf.IResolvable;
    get enableMonitoring(): cdktf.IResolvable;
    private _ephemeralBlockDevice;
    get ephemeralBlockDevice(): DataAwsLaunchConfigurationEphemeralBlockDeviceList;
    get iamInstanceProfile(): string;
    get id(): string;
    get imageId(): string;
    get instanceType(): string;
    get keyName(): string;
    private _metadataOptions;
    get metadataOptions(): DataAwsLaunchConfigurationMetadataOptionsList;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get placementTenancy(): string;
    private _rootBlockDevice;
    get rootBlockDevice(): DataAwsLaunchConfigurationRootBlockDeviceList;
    get securityGroups(): string[];
    get spotPrice(): string;
    get userData(): string;
    get vpcClassicLinkId(): string;
    get vpcClassicLinkSecurityGroups(): string[];
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-launch-configuration.d.ts.map