import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Data Sources
*/
export interface DataAwsPartitionConfig extends cdktf.TerraformMetaArguments {
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/partition aws_partition}
*/
export declare class DataAwsPartition extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_partition";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/partition aws_partition} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsPartitionConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAwsPartitionConfig);
    get dnsSuffix(): string;
    get id(): string;
    get partition(): string;
    get reverseDnsPrefix(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-partition.d.ts.map