import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS DataSync
*/
export interface DatasyncLocationHdfsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/datasync_location_hdfs#agent_arns DatasyncLocationHdfs#agent_arns}
    */
    readonly agentArns: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/datasync_location_hdfs#authentication_type DatasyncLocationHdfs#authentication_type}
    */
    readonly authenticationType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/datasync_location_hdfs#block_size DatasyncLocationHdfs#block_size}
    */
    readonly blockSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/datasync_location_hdfs#kerberos_keytab DatasyncLocationHdfs#kerberos_keytab}
    */
    readonly kerberosKeytab?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/datasync_location_hdfs#kerberos_krb5_conf DatasyncLocationHdfs#kerberos_krb5_conf}
    */
    readonly kerberosKrb5Conf?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/datasync_location_hdfs#kerberos_principal DatasyncLocationHdfs#kerberos_principal}
    */
    readonly kerberosPrincipal?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/datasync_location_hdfs#kms_key_provider_uri DatasyncLocationHdfs#kms_key_provider_uri}
    */
    readonly kmsKeyProviderUri?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/datasync_location_hdfs#replication_factor DatasyncLocationHdfs#replication_factor}
    */
    readonly replicationFactor?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/datasync_location_hdfs#simple_user DatasyncLocationHdfs#simple_user}
    */
    readonly simpleUser?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/datasync_location_hdfs#subdirectory DatasyncLocationHdfs#subdirectory}
    */
    readonly subdirectory?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/datasync_location_hdfs#tags DatasyncLocationHdfs#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/datasync_location_hdfs#tags_all DatasyncLocationHdfs#tags_all}
    */
    readonly tagsAll?: {
        [key: string]: string;
    };
    /**
    * name_node block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/datasync_location_hdfs#name_node DatasyncLocationHdfs#name_node}
    */
    readonly nameNode: DatasyncLocationHdfsNameNode[] | cdktf.IResolvable;
    /**
    * qop_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/datasync_location_hdfs#qop_configuration DatasyncLocationHdfs#qop_configuration}
    */
    readonly qopConfiguration?: DatasyncLocationHdfsQopConfiguration;
}
export interface DatasyncLocationHdfsNameNode {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/datasync_location_hdfs#hostname DatasyncLocationHdfs#hostname}
    */
    readonly hostname: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/datasync_location_hdfs#port DatasyncLocationHdfs#port}
    */
    readonly port: number;
}
export declare function datasyncLocationHdfsNameNodeToTerraform(struct?: DatasyncLocationHdfsNameNode | cdktf.IResolvable): any;
export interface DatasyncLocationHdfsQopConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/datasync_location_hdfs#data_transfer_protection DatasyncLocationHdfs#data_transfer_protection}
    */
    readonly dataTransferProtection?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/datasync_location_hdfs#rpc_protection DatasyncLocationHdfs#rpc_protection}
    */
    readonly rpcProtection?: string;
}
export declare function datasyncLocationHdfsQopConfigurationToTerraform(struct?: DatasyncLocationHdfsQopConfigurationOutputReference | DatasyncLocationHdfsQopConfiguration): any;
export declare class DatasyncLocationHdfsQopConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatasyncLocationHdfsQopConfiguration | undefined;
    set internalValue(value: DatasyncLocationHdfsQopConfiguration | undefined);
    private _dataTransferProtection?;
    get dataTransferProtection(): string;
    set dataTransferProtection(value: string);
    resetDataTransferProtection(): void;
    get dataTransferProtectionInput(): string | undefined;
    private _rpcProtection?;
    get rpcProtection(): string;
    set rpcProtection(value: string);
    resetRpcProtection(): void;
    get rpcProtectionInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/datasync_location_hdfs aws_datasync_location_hdfs}
*/
export declare class DatasyncLocationHdfs extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_datasync_location_hdfs";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/datasync_location_hdfs aws_datasync_location_hdfs} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DatasyncLocationHdfsConfig
    */
    constructor(scope: Construct, id: string, config: DatasyncLocationHdfsConfig);
    private _agentArns?;
    get agentArns(): string[];
    set agentArns(value: string[]);
    get agentArnsInput(): string[] | undefined;
    get arn(): string;
    private _authenticationType?;
    get authenticationType(): string;
    set authenticationType(value: string);
    resetAuthenticationType(): void;
    get authenticationTypeInput(): string | undefined;
    private _blockSize?;
    get blockSize(): number;
    set blockSize(value: number);
    resetBlockSize(): void;
    get blockSizeInput(): number | undefined;
    get id(): string;
    private _kerberosKeytab?;
    get kerberosKeytab(): string;
    set kerberosKeytab(value: string);
    resetKerberosKeytab(): void;
    get kerberosKeytabInput(): string | undefined;
    private _kerberosKrb5Conf?;
    get kerberosKrb5Conf(): string;
    set kerberosKrb5Conf(value: string);
    resetKerberosKrb5Conf(): void;
    get kerberosKrb5ConfInput(): string | undefined;
    private _kerberosPrincipal?;
    get kerberosPrincipal(): string;
    set kerberosPrincipal(value: string);
    resetKerberosPrincipal(): void;
    get kerberosPrincipalInput(): string | undefined;
    private _kmsKeyProviderUri?;
    get kmsKeyProviderUri(): string;
    set kmsKeyProviderUri(value: string);
    resetKmsKeyProviderUri(): void;
    get kmsKeyProviderUriInput(): string | undefined;
    private _replicationFactor?;
    get replicationFactor(): number;
    set replicationFactor(value: number);
    resetReplicationFactor(): void;
    get replicationFactorInput(): number | undefined;
    private _simpleUser?;
    get simpleUser(): string;
    set simpleUser(value: string);
    resetSimpleUser(): void;
    get simpleUserInput(): string | undefined;
    private _subdirectory?;
    get subdirectory(): string;
    set subdirectory(value: string);
    resetSubdirectory(): void;
    get subdirectoryInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tagsAll?;
    get tagsAll(): {
        [key: string]: string;
    };
    set tagsAll(value: {
        [key: string]: string;
    });
    resetTagsAll(): void;
    get tagsAllInput(): {
        [key: string]: string;
    } | undefined;
    get uri(): string;
    private _nameNode?;
    get nameNode(): DatasyncLocationHdfsNameNode[] | cdktf.IResolvable;
    set nameNode(value: DatasyncLocationHdfsNameNode[] | cdktf.IResolvable);
    get nameNodeInput(): cdktf.IResolvable | DatasyncLocationHdfsNameNode[] | undefined;
    private _qopConfiguration;
    get qopConfiguration(): DatasyncLocationHdfsQopConfigurationOutputReference;
    putQopConfiguration(value: DatasyncLocationHdfsQopConfiguration): void;
    resetQopConfiguration(): void;
    get qopConfigurationInput(): DatasyncLocationHdfsQopConfiguration | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=datasync-location-hdfs.d.ts.map