import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS DynamoDB Accelerator
*/
export interface DaxParameterGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dax_parameter_group#description DaxParameterGroup#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dax_parameter_group#name DaxParameterGroup#name}
    */
    readonly name: string;
    /**
    * parameters block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dax_parameter_group#parameters DaxParameterGroup#parameters}
    */
    readonly parameters?: DaxParameterGroupParameters[] | cdktf.IResolvable;
}
export interface DaxParameterGroupParameters {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dax_parameter_group#name DaxParameterGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dax_parameter_group#value DaxParameterGroup#value}
    */
    readonly value: string;
}
export declare function daxParameterGroupParametersToTerraform(struct?: DaxParameterGroupParameters | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/dax_parameter_group aws_dax_parameter_group}
*/
export declare class DaxParameterGroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_dax_parameter_group";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/dax_parameter_group aws_dax_parameter_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DaxParameterGroupConfig
    */
    constructor(scope: Construct, id: string, config: DaxParameterGroupConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): DaxParameterGroupParameters[] | cdktf.IResolvable;
    set parameters(value: DaxParameterGroupParameters[] | cdktf.IResolvable);
    resetParameters(): void;
    get parametersInput(): cdktf.IResolvable | DaxParameterGroupParameters[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=dax-parameter-group.d.ts.map