import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Device Farm
*/
export interface DevicefarmInstanceProfileConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/devicefarm_instance_profile#description DevicefarmInstanceProfile#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/devicefarm_instance_profile#exclude_app_packages_from_cleanup DevicefarmInstanceProfile#exclude_app_packages_from_cleanup}
    */
    readonly excludeAppPackagesFromCleanup?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/devicefarm_instance_profile#name DevicefarmInstanceProfile#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/devicefarm_instance_profile#package_cleanup DevicefarmInstanceProfile#package_cleanup}
    */
    readonly packageCleanup?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/devicefarm_instance_profile#reboot_after_use DevicefarmInstanceProfile#reboot_after_use}
    */
    readonly rebootAfterUse?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/devicefarm_instance_profile#tags DevicefarmInstanceProfile#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/devicefarm_instance_profile#tags_all DevicefarmInstanceProfile#tags_all}
    */
    readonly tagsAll?: {
        [key: string]: string;
    };
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/devicefarm_instance_profile aws_devicefarm_instance_profile}
*/
export declare class DevicefarmInstanceProfile extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_devicefarm_instance_profile";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/devicefarm_instance_profile aws_devicefarm_instance_profile} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DevicefarmInstanceProfileConfig
    */
    constructor(scope: Construct, id: string, config: DevicefarmInstanceProfileConfig);
    get arn(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _excludeAppPackagesFromCleanup?;
    get excludeAppPackagesFromCleanup(): string[];
    set excludeAppPackagesFromCleanup(value: string[]);
    resetExcludeAppPackagesFromCleanup(): void;
    get excludeAppPackagesFromCleanupInput(): string[] | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _packageCleanup?;
    get packageCleanup(): boolean | cdktf.IResolvable;
    set packageCleanup(value: boolean | cdktf.IResolvable);
    resetPackageCleanup(): void;
    get packageCleanupInput(): boolean | cdktf.IResolvable | undefined;
    private _rebootAfterUse?;
    get rebootAfterUse(): boolean | cdktf.IResolvable;
    set rebootAfterUse(value: boolean | cdktf.IResolvable);
    resetRebootAfterUse(): void;
    get rebootAfterUseInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tagsAll?;
    get tagsAll(): {
        [key: string]: string;
    };
    set tagsAll(value: {
        [key: string]: string;
    });
    resetTagsAll(): void;
    get tagsAllInput(): {
        [key: string]: string;
    } | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=devicefarm-instance-profile.d.ts.map