import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Direct Connect
*/
export interface DxGatewayAssociationProposalConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dx_gateway_association_proposal#allowed_prefixes DxGatewayAssociationProposal#allowed_prefixes}
    */
    readonly allowedPrefixes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dx_gateway_association_proposal#associated_gateway_id DxGatewayAssociationProposal#associated_gateway_id}
    */
    readonly associatedGatewayId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dx_gateway_association_proposal#dx_gateway_id DxGatewayAssociationProposal#dx_gateway_id}
    */
    readonly dxGatewayId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dx_gateway_association_proposal#dx_gateway_owner_account_id DxGatewayAssociationProposal#dx_gateway_owner_account_id}
    */
    readonly dxGatewayOwnerAccountId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/dx_gateway_association_proposal aws_dx_gateway_association_proposal}
*/
export declare class DxGatewayAssociationProposal extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_dx_gateway_association_proposal";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/dx_gateway_association_proposal aws_dx_gateway_association_proposal} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DxGatewayAssociationProposalConfig
    */
    constructor(scope: Construct, id: string, config: DxGatewayAssociationProposalConfig);
    private _allowedPrefixes?;
    get allowedPrefixes(): string[];
    set allowedPrefixes(value: string[]);
    resetAllowedPrefixes(): void;
    get allowedPrefixesInput(): string[] | undefined;
    private _associatedGatewayId?;
    get associatedGatewayId(): string;
    set associatedGatewayId(value: string);
    get associatedGatewayIdInput(): string | undefined;
    get associatedGatewayOwnerAccountId(): string;
    get associatedGatewayType(): string;
    private _dxGatewayId?;
    get dxGatewayId(): string;
    set dxGatewayId(value: string);
    get dxGatewayIdInput(): string | undefined;
    private _dxGatewayOwnerAccountId?;
    get dxGatewayOwnerAccountId(): string;
    set dxGatewayOwnerAccountId(value: string);
    get dxGatewayOwnerAccountIdInput(): string | undefined;
    get id(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=dx-gateway-association-proposal.d.ts.map