import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Directory Service
*/
export interface DataAwsDirectoryServiceDirectoryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/directory_service_directory#directory_id DataAwsDirectoryServiceDirectory#directory_id}
    */
    readonly directoryId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/directory_service_directory#tags DataAwsDirectoryServiceDirectory#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
}
export interface DataAwsDirectoryServiceDirectoryConnectSettings {
}
export declare function dataAwsDirectoryServiceDirectoryConnectSettingsToTerraform(struct?: DataAwsDirectoryServiceDirectoryConnectSettings): any;
export declare class DataAwsDirectoryServiceDirectoryConnectSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsDirectoryServiceDirectoryConnectSettings | undefined;
    set internalValue(value: DataAwsDirectoryServiceDirectoryConnectSettings | undefined);
    get availabilityZones(): string[];
    get connectIps(): string[];
    get customerDnsIps(): string[];
    get customerUsername(): string;
    get subnetIds(): string[];
    get vpcId(): string;
}
export declare class DataAwsDirectoryServiceDirectoryConnectSettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsDirectoryServiceDirectoryConnectSettingsOutputReference;
}
export interface DataAwsDirectoryServiceDirectoryVpcSettings {
}
export declare function dataAwsDirectoryServiceDirectoryVpcSettingsToTerraform(struct?: DataAwsDirectoryServiceDirectoryVpcSettings): any;
export declare class DataAwsDirectoryServiceDirectoryVpcSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsDirectoryServiceDirectoryVpcSettings | undefined;
    set internalValue(value: DataAwsDirectoryServiceDirectoryVpcSettings | undefined);
    get availabilityZones(): string[];
    get subnetIds(): string[];
    get vpcId(): string;
}
export declare class DataAwsDirectoryServiceDirectoryVpcSettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsDirectoryServiceDirectoryVpcSettingsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/directory_service_directory aws_directory_service_directory}
*/
export declare class DataAwsDirectoryServiceDirectory extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_directory_service_directory";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/directory_service_directory aws_directory_service_directory} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsDirectoryServiceDirectoryConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsDirectoryServiceDirectoryConfig);
    get accessUrl(): string;
    get alias(): string;
    private _connectSettings;
    get connectSettings(): DataAwsDirectoryServiceDirectoryConnectSettingsList;
    get description(): string;
    private _directoryId?;
    get directoryId(): string;
    set directoryId(value: string);
    get directoryIdInput(): string | undefined;
    get dnsIpAddresses(): string[];
    get edition(): string;
    get enableSso(): cdktf.IResolvable;
    get id(): string;
    get name(): string;
    get securityGroupId(): string;
    get shortName(): string;
    get size(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get type(): string;
    private _vpcSettings;
    get vpcSettings(): DataAwsDirectoryServiceDirectoryVpcSettingsList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-directory-service-directory.d.ts.map