"use strict";
var _a, _b, _c, _d, _e, _f;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DmsEndpoint = exports.DmsEndpointS3SettingsOutputReference = exports.dmsEndpointS3SettingsToTerraform = exports.DmsEndpointMongodbSettingsOutputReference = exports.dmsEndpointMongodbSettingsToTerraform = exports.DmsEndpointKinesisSettingsOutputReference = exports.dmsEndpointKinesisSettingsToTerraform = exports.DmsEndpointKafkaSettingsOutputReference = exports.dmsEndpointKafkaSettingsToTerraform = exports.DmsEndpointElasticsearchSettingsOutputReference = exports.dmsEndpointElasticsearchSettingsToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function dmsEndpointElasticsearchSettingsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        endpoint_uri: cdktf.stringToTerraform(struct.endpointUri),
        error_retry_duration: cdktf.numberToTerraform(struct.errorRetryDuration),
        full_load_error_percentage: cdktf.numberToTerraform(struct.fullLoadErrorPercentage),
        service_access_role_arn: cdktf.stringToTerraform(struct.serviceAccessRoleArn),
    };
}
exports.dmsEndpointElasticsearchSettingsToTerraform = dmsEndpointElasticsearchSettingsToTerraform;
class DmsEndpointElasticsearchSettingsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._endpointUri !== undefined) {
            hasAnyValues = true;
            internalValueResult.endpointUri = this._endpointUri;
        }
        if (this._errorRetryDuration !== undefined) {
            hasAnyValues = true;
            internalValueResult.errorRetryDuration = this._errorRetryDuration;
        }
        if (this._fullLoadErrorPercentage !== undefined) {
            hasAnyValues = true;
            internalValueResult.fullLoadErrorPercentage = this._fullLoadErrorPercentage;
        }
        if (this._serviceAccessRoleArn !== undefined) {
            hasAnyValues = true;
            internalValueResult.serviceAccessRoleArn = this._serviceAccessRoleArn;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._endpointUri = undefined;
            this._errorRetryDuration = undefined;
            this._fullLoadErrorPercentage = undefined;
            this._serviceAccessRoleArn = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._endpointUri = value.endpointUri;
            this._errorRetryDuration = value.errorRetryDuration;
            this._fullLoadErrorPercentage = value.fullLoadErrorPercentage;
            this._serviceAccessRoleArn = value.serviceAccessRoleArn;
        }
    }
    get endpointUri() {
        return this.getStringAttribute('endpoint_uri');
    }
    set endpointUri(value) {
        this._endpointUri = value;
    }
    // Temporarily expose input value. Use with caution.
    get endpointUriInput() {
        return this._endpointUri;
    }
    get errorRetryDuration() {
        return this.getNumberAttribute('error_retry_duration');
    }
    set errorRetryDuration(value) {
        this._errorRetryDuration = value;
    }
    resetErrorRetryDuration() {
        this._errorRetryDuration = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get errorRetryDurationInput() {
        return this._errorRetryDuration;
    }
    get fullLoadErrorPercentage() {
        return this.getNumberAttribute('full_load_error_percentage');
    }
    set fullLoadErrorPercentage(value) {
        this._fullLoadErrorPercentage = value;
    }
    resetFullLoadErrorPercentage() {
        this._fullLoadErrorPercentage = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fullLoadErrorPercentageInput() {
        return this._fullLoadErrorPercentage;
    }
    get serviceAccessRoleArn() {
        return this.getStringAttribute('service_access_role_arn');
    }
    set serviceAccessRoleArn(value) {
        this._serviceAccessRoleArn = value;
    }
    // Temporarily expose input value. Use with caution.
    get serviceAccessRoleArnInput() {
        return this._serviceAccessRoleArn;
    }
}
exports.DmsEndpointElasticsearchSettingsOutputReference = DmsEndpointElasticsearchSettingsOutputReference;
_a = JSII_RTTI_SYMBOL_1;
DmsEndpointElasticsearchSettingsOutputReference[_a] = { fqn: "@cdktf/provider-aws.dms.DmsEndpointElasticsearchSettingsOutputReference", version: "7.0.64" };
function dmsEndpointKafkaSettingsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        broker: cdktf.stringToTerraform(struct.broker),
        include_control_details: cdktf.booleanToTerraform(struct.includeControlDetails),
        include_null_and_empty: cdktf.booleanToTerraform(struct.includeNullAndEmpty),
        include_partition_value: cdktf.booleanToTerraform(struct.includePartitionValue),
        include_table_alter_operations: cdktf.booleanToTerraform(struct.includeTableAlterOperations),
        include_transaction_details: cdktf.booleanToTerraform(struct.includeTransactionDetails),
        message_format: cdktf.stringToTerraform(struct.messageFormat),
        message_max_bytes: cdktf.numberToTerraform(struct.messageMaxBytes),
        no_hex_prefix: cdktf.booleanToTerraform(struct.noHexPrefix),
        partition_include_schema_table: cdktf.booleanToTerraform(struct.partitionIncludeSchemaTable),
        sasl_password: cdktf.stringToTerraform(struct.saslPassword),
        sasl_username: cdktf.stringToTerraform(struct.saslUsername),
        security_protocol: cdktf.stringToTerraform(struct.securityProtocol),
        ssl_ca_certificate_arn: cdktf.stringToTerraform(struct.sslCaCertificateArn),
        ssl_client_certificate_arn: cdktf.stringToTerraform(struct.sslClientCertificateArn),
        ssl_client_key_arn: cdktf.stringToTerraform(struct.sslClientKeyArn),
        ssl_client_key_password: cdktf.stringToTerraform(struct.sslClientKeyPassword),
        topic: cdktf.stringToTerraform(struct.topic),
    };
}
exports.dmsEndpointKafkaSettingsToTerraform = dmsEndpointKafkaSettingsToTerraform;
class DmsEndpointKafkaSettingsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._broker !== undefined) {
            hasAnyValues = true;
            internalValueResult.broker = this._broker;
        }
        if (this._includeControlDetails !== undefined) {
            hasAnyValues = true;
            internalValueResult.includeControlDetails = this._includeControlDetails;
        }
        if (this._includeNullAndEmpty !== undefined) {
            hasAnyValues = true;
            internalValueResult.includeNullAndEmpty = this._includeNullAndEmpty;
        }
        if (this._includePartitionValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.includePartitionValue = this._includePartitionValue;
        }
        if (this._includeTableAlterOperations !== undefined) {
            hasAnyValues = true;
            internalValueResult.includeTableAlterOperations = this._includeTableAlterOperations;
        }
        if (this._includeTransactionDetails !== undefined) {
            hasAnyValues = true;
            internalValueResult.includeTransactionDetails = this._includeTransactionDetails;
        }
        if (this._messageFormat !== undefined) {
            hasAnyValues = true;
            internalValueResult.messageFormat = this._messageFormat;
        }
        if (this._messageMaxBytes !== undefined) {
            hasAnyValues = true;
            internalValueResult.messageMaxBytes = this._messageMaxBytes;
        }
        if (this._noHexPrefix !== undefined) {
            hasAnyValues = true;
            internalValueResult.noHexPrefix = this._noHexPrefix;
        }
        if (this._partitionIncludeSchemaTable !== undefined) {
            hasAnyValues = true;
            internalValueResult.partitionIncludeSchemaTable = this._partitionIncludeSchemaTable;
        }
        if (this._saslPassword !== undefined) {
            hasAnyValues = true;
            internalValueResult.saslPassword = this._saslPassword;
        }
        if (this._saslUsername !== undefined) {
            hasAnyValues = true;
            internalValueResult.saslUsername = this._saslUsername;
        }
        if (this._securityProtocol !== undefined) {
            hasAnyValues = true;
            internalValueResult.securityProtocol = this._securityProtocol;
        }
        if (this._sslCaCertificateArn !== undefined) {
            hasAnyValues = true;
            internalValueResult.sslCaCertificateArn = this._sslCaCertificateArn;
        }
        if (this._sslClientCertificateArn !== undefined) {
            hasAnyValues = true;
            internalValueResult.sslClientCertificateArn = this._sslClientCertificateArn;
        }
        if (this._sslClientKeyArn !== undefined) {
            hasAnyValues = true;
            internalValueResult.sslClientKeyArn = this._sslClientKeyArn;
        }
        if (this._sslClientKeyPassword !== undefined) {
            hasAnyValues = true;
            internalValueResult.sslClientKeyPassword = this._sslClientKeyPassword;
        }
        if (this._topic !== undefined) {
            hasAnyValues = true;
            internalValueResult.topic = this._topic;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._broker = undefined;
            this._includeControlDetails = undefined;
            this._includeNullAndEmpty = undefined;
            this._includePartitionValue = undefined;
            this._includeTableAlterOperations = undefined;
            this._includeTransactionDetails = undefined;
            this._messageFormat = undefined;
            this._messageMaxBytes = undefined;
            this._noHexPrefix = undefined;
            this._partitionIncludeSchemaTable = undefined;
            this._saslPassword = undefined;
            this._saslUsername = undefined;
            this._securityProtocol = undefined;
            this._sslCaCertificateArn = undefined;
            this._sslClientCertificateArn = undefined;
            this._sslClientKeyArn = undefined;
            this._sslClientKeyPassword = undefined;
            this._topic = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._broker = value.broker;
            this._includeControlDetails = value.includeControlDetails;
            this._includeNullAndEmpty = value.includeNullAndEmpty;
            this._includePartitionValue = value.includePartitionValue;
            this._includeTableAlterOperations = value.includeTableAlterOperations;
            this._includeTransactionDetails = value.includeTransactionDetails;
            this._messageFormat = value.messageFormat;
            this._messageMaxBytes = value.messageMaxBytes;
            this._noHexPrefix = value.noHexPrefix;
            this._partitionIncludeSchemaTable = value.partitionIncludeSchemaTable;
            this._saslPassword = value.saslPassword;
            this._saslUsername = value.saslUsername;
            this._securityProtocol = value.securityProtocol;
            this._sslCaCertificateArn = value.sslCaCertificateArn;
            this._sslClientCertificateArn = value.sslClientCertificateArn;
            this._sslClientKeyArn = value.sslClientKeyArn;
            this._sslClientKeyPassword = value.sslClientKeyPassword;
            this._topic = value.topic;
        }
    }
    get broker() {
        return this.getStringAttribute('broker');
    }
    set broker(value) {
        this._broker = value;
    }
    // Temporarily expose input value. Use with caution.
    get brokerInput() {
        return this._broker;
    }
    get includeControlDetails() {
        return this.getBooleanAttribute('include_control_details');
    }
    set includeControlDetails(value) {
        this._includeControlDetails = value;
    }
    resetIncludeControlDetails() {
        this._includeControlDetails = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get includeControlDetailsInput() {
        return this._includeControlDetails;
    }
    get includeNullAndEmpty() {
        return this.getBooleanAttribute('include_null_and_empty');
    }
    set includeNullAndEmpty(value) {
        this._includeNullAndEmpty = value;
    }
    resetIncludeNullAndEmpty() {
        this._includeNullAndEmpty = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get includeNullAndEmptyInput() {
        return this._includeNullAndEmpty;
    }
    get includePartitionValue() {
        return this.getBooleanAttribute('include_partition_value');
    }
    set includePartitionValue(value) {
        this._includePartitionValue = value;
    }
    resetIncludePartitionValue() {
        this._includePartitionValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get includePartitionValueInput() {
        return this._includePartitionValue;
    }
    get includeTableAlterOperations() {
        return this.getBooleanAttribute('include_table_alter_operations');
    }
    set includeTableAlterOperations(value) {
        this._includeTableAlterOperations = value;
    }
    resetIncludeTableAlterOperations() {
        this._includeTableAlterOperations = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get includeTableAlterOperationsInput() {
        return this._includeTableAlterOperations;
    }
    get includeTransactionDetails() {
        return this.getBooleanAttribute('include_transaction_details');
    }
    set includeTransactionDetails(value) {
        this._includeTransactionDetails = value;
    }
    resetIncludeTransactionDetails() {
        this._includeTransactionDetails = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get includeTransactionDetailsInput() {
        return this._includeTransactionDetails;
    }
    get messageFormat() {
        return this.getStringAttribute('message_format');
    }
    set messageFormat(value) {
        this._messageFormat = value;
    }
    resetMessageFormat() {
        this._messageFormat = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get messageFormatInput() {
        return this._messageFormat;
    }
    get messageMaxBytes() {
        return this.getNumberAttribute('message_max_bytes');
    }
    set messageMaxBytes(value) {
        this._messageMaxBytes = value;
    }
    resetMessageMaxBytes() {
        this._messageMaxBytes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get messageMaxBytesInput() {
        return this._messageMaxBytes;
    }
    get noHexPrefix() {
        return this.getBooleanAttribute('no_hex_prefix');
    }
    set noHexPrefix(value) {
        this._noHexPrefix = value;
    }
    resetNoHexPrefix() {
        this._noHexPrefix = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get noHexPrefixInput() {
        return this._noHexPrefix;
    }
    get partitionIncludeSchemaTable() {
        return this.getBooleanAttribute('partition_include_schema_table');
    }
    set partitionIncludeSchemaTable(value) {
        this._partitionIncludeSchemaTable = value;
    }
    resetPartitionIncludeSchemaTable() {
        this._partitionIncludeSchemaTable = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get partitionIncludeSchemaTableInput() {
        return this._partitionIncludeSchemaTable;
    }
    get saslPassword() {
        return this.getStringAttribute('sasl_password');
    }
    set saslPassword(value) {
        this._saslPassword = value;
    }
    resetSaslPassword() {
        this._saslPassword = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saslPasswordInput() {
        return this._saslPassword;
    }
    get saslUsername() {
        return this.getStringAttribute('sasl_username');
    }
    set saslUsername(value) {
        this._saslUsername = value;
    }
    resetSaslUsername() {
        this._saslUsername = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saslUsernameInput() {
        return this._saslUsername;
    }
    get securityProtocol() {
        return this.getStringAttribute('security_protocol');
    }
    set securityProtocol(value) {
        this._securityProtocol = value;
    }
    resetSecurityProtocol() {
        this._securityProtocol = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get securityProtocolInput() {
        return this._securityProtocol;
    }
    get sslCaCertificateArn() {
        return this.getStringAttribute('ssl_ca_certificate_arn');
    }
    set sslCaCertificateArn(value) {
        this._sslCaCertificateArn = value;
    }
    resetSslCaCertificateArn() {
        this._sslCaCertificateArn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sslCaCertificateArnInput() {
        return this._sslCaCertificateArn;
    }
    get sslClientCertificateArn() {
        return this.getStringAttribute('ssl_client_certificate_arn');
    }
    set sslClientCertificateArn(value) {
        this._sslClientCertificateArn = value;
    }
    resetSslClientCertificateArn() {
        this._sslClientCertificateArn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sslClientCertificateArnInput() {
        return this._sslClientCertificateArn;
    }
    get sslClientKeyArn() {
        return this.getStringAttribute('ssl_client_key_arn');
    }
    set sslClientKeyArn(value) {
        this._sslClientKeyArn = value;
    }
    resetSslClientKeyArn() {
        this._sslClientKeyArn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sslClientKeyArnInput() {
        return this._sslClientKeyArn;
    }
    get sslClientKeyPassword() {
        return this.getStringAttribute('ssl_client_key_password');
    }
    set sslClientKeyPassword(value) {
        this._sslClientKeyPassword = value;
    }
    resetSslClientKeyPassword() {
        this._sslClientKeyPassword = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sslClientKeyPasswordInput() {
        return this._sslClientKeyPassword;
    }
    get topic() {
        return this.getStringAttribute('topic');
    }
    set topic(value) {
        this._topic = value;
    }
    resetTopic() {
        this._topic = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get topicInput() {
        return this._topic;
    }
}
exports.DmsEndpointKafkaSettingsOutputReference = DmsEndpointKafkaSettingsOutputReference;
_b = JSII_RTTI_SYMBOL_1;
DmsEndpointKafkaSettingsOutputReference[_b] = { fqn: "@cdktf/provider-aws.dms.DmsEndpointKafkaSettingsOutputReference", version: "7.0.64" };
function dmsEndpointKinesisSettingsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        include_control_details: cdktf.booleanToTerraform(struct.includeControlDetails),
        include_null_and_empty: cdktf.booleanToTerraform(struct.includeNullAndEmpty),
        include_partition_value: cdktf.booleanToTerraform(struct.includePartitionValue),
        include_table_alter_operations: cdktf.booleanToTerraform(struct.includeTableAlterOperations),
        include_transaction_details: cdktf.booleanToTerraform(struct.includeTransactionDetails),
        message_format: cdktf.stringToTerraform(struct.messageFormat),
        partition_include_schema_table: cdktf.booleanToTerraform(struct.partitionIncludeSchemaTable),
        service_access_role_arn: cdktf.stringToTerraform(struct.serviceAccessRoleArn),
        stream_arn: cdktf.stringToTerraform(struct.streamArn),
    };
}
exports.dmsEndpointKinesisSettingsToTerraform = dmsEndpointKinesisSettingsToTerraform;
class DmsEndpointKinesisSettingsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._includeControlDetails !== undefined) {
            hasAnyValues = true;
            internalValueResult.includeControlDetails = this._includeControlDetails;
        }
        if (this._includeNullAndEmpty !== undefined) {
            hasAnyValues = true;
            internalValueResult.includeNullAndEmpty = this._includeNullAndEmpty;
        }
        if (this._includePartitionValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.includePartitionValue = this._includePartitionValue;
        }
        if (this._includeTableAlterOperations !== undefined) {
            hasAnyValues = true;
            internalValueResult.includeTableAlterOperations = this._includeTableAlterOperations;
        }
        if (this._includeTransactionDetails !== undefined) {
            hasAnyValues = true;
            internalValueResult.includeTransactionDetails = this._includeTransactionDetails;
        }
        if (this._messageFormat !== undefined) {
            hasAnyValues = true;
            internalValueResult.messageFormat = this._messageFormat;
        }
        if (this._partitionIncludeSchemaTable !== undefined) {
            hasAnyValues = true;
            internalValueResult.partitionIncludeSchemaTable = this._partitionIncludeSchemaTable;
        }
        if (this._serviceAccessRoleArn !== undefined) {
            hasAnyValues = true;
            internalValueResult.serviceAccessRoleArn = this._serviceAccessRoleArn;
        }
        if (this._streamArn !== undefined) {
            hasAnyValues = true;
            internalValueResult.streamArn = this._streamArn;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._includeControlDetails = undefined;
            this._includeNullAndEmpty = undefined;
            this._includePartitionValue = undefined;
            this._includeTableAlterOperations = undefined;
            this._includeTransactionDetails = undefined;
            this._messageFormat = undefined;
            this._partitionIncludeSchemaTable = undefined;
            this._serviceAccessRoleArn = undefined;
            this._streamArn = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._includeControlDetails = value.includeControlDetails;
            this._includeNullAndEmpty = value.includeNullAndEmpty;
            this._includePartitionValue = value.includePartitionValue;
            this._includeTableAlterOperations = value.includeTableAlterOperations;
            this._includeTransactionDetails = value.includeTransactionDetails;
            this._messageFormat = value.messageFormat;
            this._partitionIncludeSchemaTable = value.partitionIncludeSchemaTable;
            this._serviceAccessRoleArn = value.serviceAccessRoleArn;
            this._streamArn = value.streamArn;
        }
    }
    get includeControlDetails() {
        return this.getBooleanAttribute('include_control_details');
    }
    set includeControlDetails(value) {
        this._includeControlDetails = value;
    }
    resetIncludeControlDetails() {
        this._includeControlDetails = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get includeControlDetailsInput() {
        return this._includeControlDetails;
    }
    get includeNullAndEmpty() {
        return this.getBooleanAttribute('include_null_and_empty');
    }
    set includeNullAndEmpty(value) {
        this._includeNullAndEmpty = value;
    }
    resetIncludeNullAndEmpty() {
        this._includeNullAndEmpty = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get includeNullAndEmptyInput() {
        return this._includeNullAndEmpty;
    }
    get includePartitionValue() {
        return this.getBooleanAttribute('include_partition_value');
    }
    set includePartitionValue(value) {
        this._includePartitionValue = value;
    }
    resetIncludePartitionValue() {
        this._includePartitionValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get includePartitionValueInput() {
        return this._includePartitionValue;
    }
    get includeTableAlterOperations() {
        return this.getBooleanAttribute('include_table_alter_operations');
    }
    set includeTableAlterOperations(value) {
        this._includeTableAlterOperations = value;
    }
    resetIncludeTableAlterOperations() {
        this._includeTableAlterOperations = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get includeTableAlterOperationsInput() {
        return this._includeTableAlterOperations;
    }
    get includeTransactionDetails() {
        return this.getBooleanAttribute('include_transaction_details');
    }
    set includeTransactionDetails(value) {
        this._includeTransactionDetails = value;
    }
    resetIncludeTransactionDetails() {
        this._includeTransactionDetails = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get includeTransactionDetailsInput() {
        return this._includeTransactionDetails;
    }
    get messageFormat() {
        return this.getStringAttribute('message_format');
    }
    set messageFormat(value) {
        this._messageFormat = value;
    }
    resetMessageFormat() {
        this._messageFormat = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get messageFormatInput() {
        return this._messageFormat;
    }
    get partitionIncludeSchemaTable() {
        return this.getBooleanAttribute('partition_include_schema_table');
    }
    set partitionIncludeSchemaTable(value) {
        this._partitionIncludeSchemaTable = value;
    }
    resetPartitionIncludeSchemaTable() {
        this._partitionIncludeSchemaTable = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get partitionIncludeSchemaTableInput() {
        return this._partitionIncludeSchemaTable;
    }
    get serviceAccessRoleArn() {
        return this.getStringAttribute('service_access_role_arn');
    }
    set serviceAccessRoleArn(value) {
        this._serviceAccessRoleArn = value;
    }
    resetServiceAccessRoleArn() {
        this._serviceAccessRoleArn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get serviceAccessRoleArnInput() {
        return this._serviceAccessRoleArn;
    }
    get streamArn() {
        return this.getStringAttribute('stream_arn');
    }
    set streamArn(value) {
        this._streamArn = value;
    }
    resetStreamArn() {
        this._streamArn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get streamArnInput() {
        return this._streamArn;
    }
}
exports.DmsEndpointKinesisSettingsOutputReference = DmsEndpointKinesisSettingsOutputReference;
_c = JSII_RTTI_SYMBOL_1;
DmsEndpointKinesisSettingsOutputReference[_c] = { fqn: "@cdktf/provider-aws.dms.DmsEndpointKinesisSettingsOutputReference", version: "7.0.64" };
function dmsEndpointMongodbSettingsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        auth_mechanism: cdktf.stringToTerraform(struct.authMechanism),
        auth_source: cdktf.stringToTerraform(struct.authSource),
        auth_type: cdktf.stringToTerraform(struct.authType),
        docs_to_investigate: cdktf.stringToTerraform(struct.docsToInvestigate),
        extract_doc_id: cdktf.stringToTerraform(struct.extractDocId),
        nesting_level: cdktf.stringToTerraform(struct.nestingLevel),
    };
}
exports.dmsEndpointMongodbSettingsToTerraform = dmsEndpointMongodbSettingsToTerraform;
class DmsEndpointMongodbSettingsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._authMechanism !== undefined) {
            hasAnyValues = true;
            internalValueResult.authMechanism = this._authMechanism;
        }
        if (this._authSource !== undefined) {
            hasAnyValues = true;
            internalValueResult.authSource = this._authSource;
        }
        if (this._authType !== undefined) {
            hasAnyValues = true;
            internalValueResult.authType = this._authType;
        }
        if (this._docsToInvestigate !== undefined) {
            hasAnyValues = true;
            internalValueResult.docsToInvestigate = this._docsToInvestigate;
        }
        if (this._extractDocId !== undefined) {
            hasAnyValues = true;
            internalValueResult.extractDocId = this._extractDocId;
        }
        if (this._nestingLevel !== undefined) {
            hasAnyValues = true;
            internalValueResult.nestingLevel = this._nestingLevel;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._authMechanism = undefined;
            this._authSource = undefined;
            this._authType = undefined;
            this._docsToInvestigate = undefined;
            this._extractDocId = undefined;
            this._nestingLevel = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._authMechanism = value.authMechanism;
            this._authSource = value.authSource;
            this._authType = value.authType;
            this._docsToInvestigate = value.docsToInvestigate;
            this._extractDocId = value.extractDocId;
            this._nestingLevel = value.nestingLevel;
        }
    }
    get authMechanism() {
        return this.getStringAttribute('auth_mechanism');
    }
    set authMechanism(value) {
        this._authMechanism = value;
    }
    resetAuthMechanism() {
        this._authMechanism = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get authMechanismInput() {
        return this._authMechanism;
    }
    get authSource() {
        return this.getStringAttribute('auth_source');
    }
    set authSource(value) {
        this._authSource = value;
    }
    resetAuthSource() {
        this._authSource = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get authSourceInput() {
        return this._authSource;
    }
    get authType() {
        return this.getStringAttribute('auth_type');
    }
    set authType(value) {
        this._authType = value;
    }
    resetAuthType() {
        this._authType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get authTypeInput() {
        return this._authType;
    }
    get docsToInvestigate() {
        return this.getStringAttribute('docs_to_investigate');
    }
    set docsToInvestigate(value) {
        this._docsToInvestigate = value;
    }
    resetDocsToInvestigate() {
        this._docsToInvestigate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get docsToInvestigateInput() {
        return this._docsToInvestigate;
    }
    get extractDocId() {
        return this.getStringAttribute('extract_doc_id');
    }
    set extractDocId(value) {
        this._extractDocId = value;
    }
    resetExtractDocId() {
        this._extractDocId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get extractDocIdInput() {
        return this._extractDocId;
    }
    get nestingLevel() {
        return this.getStringAttribute('nesting_level');
    }
    set nestingLevel(value) {
        this._nestingLevel = value;
    }
    resetNestingLevel() {
        this._nestingLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nestingLevelInput() {
        return this._nestingLevel;
    }
}
exports.DmsEndpointMongodbSettingsOutputReference = DmsEndpointMongodbSettingsOutputReference;
_d = JSII_RTTI_SYMBOL_1;
DmsEndpointMongodbSettingsOutputReference[_d] = { fqn: "@cdktf/provider-aws.dms.DmsEndpointMongodbSettingsOutputReference", version: "7.0.64" };
function dmsEndpointS3SettingsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        add_column_name: cdktf.booleanToTerraform(struct.addColumnName),
        bucket_folder: cdktf.stringToTerraform(struct.bucketFolder),
        bucket_name: cdktf.stringToTerraform(struct.bucketName),
        canned_acl_for_objects: cdktf.stringToTerraform(struct.cannedAclForObjects),
        cdc_inserts_and_updates: cdktf.booleanToTerraform(struct.cdcInsertsAndUpdates),
        cdc_inserts_only: cdktf.booleanToTerraform(struct.cdcInsertsOnly),
        cdc_max_batch_interval: cdktf.numberToTerraform(struct.cdcMaxBatchInterval),
        cdc_min_file_size: cdktf.numberToTerraform(struct.cdcMinFileSize),
        cdc_path: cdktf.stringToTerraform(struct.cdcPath),
        compression_type: cdktf.stringToTerraform(struct.compressionType),
        csv_delimiter: cdktf.stringToTerraform(struct.csvDelimiter),
        csv_no_sup_value: cdktf.stringToTerraform(struct.csvNoSupValue),
        csv_null_value: cdktf.stringToTerraform(struct.csvNullValue),
        csv_row_delimiter: cdktf.stringToTerraform(struct.csvRowDelimiter),
        data_format: cdktf.stringToTerraform(struct.dataFormat),
        data_page_size: cdktf.numberToTerraform(struct.dataPageSize),
        date_partition_delimiter: cdktf.stringToTerraform(struct.datePartitionDelimiter),
        date_partition_enabled: cdktf.booleanToTerraform(struct.datePartitionEnabled),
        date_partition_sequence: cdktf.stringToTerraform(struct.datePartitionSequence),
        dict_page_size_limit: cdktf.numberToTerraform(struct.dictPageSizeLimit),
        enable_statistics: cdktf.booleanToTerraform(struct.enableStatistics),
        encoding_type: cdktf.stringToTerraform(struct.encodingType),
        encryption_mode: cdktf.stringToTerraform(struct.encryptionMode),
        external_table_definition: cdktf.stringToTerraform(struct.externalTableDefinition),
        ignore_headers_row: cdktf.numberToTerraform(struct.ignoreHeadersRow),
        include_op_for_full_load: cdktf.booleanToTerraform(struct.includeOpForFullLoad),
        max_file_size: cdktf.numberToTerraform(struct.maxFileSize),
        parquet_timestamp_in_millisecond: cdktf.booleanToTerraform(struct.parquetTimestampInMillisecond),
        parquet_version: cdktf.stringToTerraform(struct.parquetVersion),
        preserve_transactions: cdktf.booleanToTerraform(struct.preserveTransactions),
        rfc_4180: cdktf.booleanToTerraform(struct.rfc4180),
        row_group_length: cdktf.numberToTerraform(struct.rowGroupLength),
        server_side_encryption_kms_key_id: cdktf.stringToTerraform(struct.serverSideEncryptionKmsKeyId),
        service_access_role_arn: cdktf.stringToTerraform(struct.serviceAccessRoleArn),
        timestamp_column_name: cdktf.stringToTerraform(struct.timestampColumnName),
        use_csv_no_sup_value: cdktf.booleanToTerraform(struct.useCsvNoSupValue),
    };
}
exports.dmsEndpointS3SettingsToTerraform = dmsEndpointS3SettingsToTerraform;
class DmsEndpointS3SettingsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._addColumnName !== undefined) {
            hasAnyValues = true;
            internalValueResult.addColumnName = this._addColumnName;
        }
        if (this._bucketFolder !== undefined) {
            hasAnyValues = true;
            internalValueResult.bucketFolder = this._bucketFolder;
        }
        if (this._bucketName !== undefined) {
            hasAnyValues = true;
            internalValueResult.bucketName = this._bucketName;
        }
        if (this._cannedAclForObjects !== undefined) {
            hasAnyValues = true;
            internalValueResult.cannedAclForObjects = this._cannedAclForObjects;
        }
        if (this._cdcInsertsAndUpdates !== undefined) {
            hasAnyValues = true;
            internalValueResult.cdcInsertsAndUpdates = this._cdcInsertsAndUpdates;
        }
        if (this._cdcInsertsOnly !== undefined) {
            hasAnyValues = true;
            internalValueResult.cdcInsertsOnly = this._cdcInsertsOnly;
        }
        if (this._cdcMaxBatchInterval !== undefined) {
            hasAnyValues = true;
            internalValueResult.cdcMaxBatchInterval = this._cdcMaxBatchInterval;
        }
        if (this._cdcMinFileSize !== undefined) {
            hasAnyValues = true;
            internalValueResult.cdcMinFileSize = this._cdcMinFileSize;
        }
        if (this._cdcPath !== undefined) {
            hasAnyValues = true;
            internalValueResult.cdcPath = this._cdcPath;
        }
        if (this._compressionType !== undefined) {
            hasAnyValues = true;
            internalValueResult.compressionType = this._compressionType;
        }
        if (this._csvDelimiter !== undefined) {
            hasAnyValues = true;
            internalValueResult.csvDelimiter = this._csvDelimiter;
        }
        if (this._csvNoSupValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.csvNoSupValue = this._csvNoSupValue;
        }
        if (this._csvNullValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.csvNullValue = this._csvNullValue;
        }
        if (this._csvRowDelimiter !== undefined) {
            hasAnyValues = true;
            internalValueResult.csvRowDelimiter = this._csvRowDelimiter;
        }
        if (this._dataFormat !== undefined) {
            hasAnyValues = true;
            internalValueResult.dataFormat = this._dataFormat;
        }
        if (this._dataPageSize !== undefined) {
            hasAnyValues = true;
            internalValueResult.dataPageSize = this._dataPageSize;
        }
        if (this._datePartitionDelimiter !== undefined) {
            hasAnyValues = true;
            internalValueResult.datePartitionDelimiter = this._datePartitionDelimiter;
        }
        if (this._datePartitionEnabled !== undefined) {
            hasAnyValues = true;
            internalValueResult.datePartitionEnabled = this._datePartitionEnabled;
        }
        if (this._datePartitionSequence !== undefined) {
            hasAnyValues = true;
            internalValueResult.datePartitionSequence = this._datePartitionSequence;
        }
        if (this._dictPageSizeLimit !== undefined) {
            hasAnyValues = true;
            internalValueResult.dictPageSizeLimit = this._dictPageSizeLimit;
        }
        if (this._enableStatistics !== undefined) {
            hasAnyValues = true;
            internalValueResult.enableStatistics = this._enableStatistics;
        }
        if (this._encodingType !== undefined) {
            hasAnyValues = true;
            internalValueResult.encodingType = this._encodingType;
        }
        if (this._encryptionMode !== undefined) {
            hasAnyValues = true;
            internalValueResult.encryptionMode = this._encryptionMode;
        }
        if (this._externalTableDefinition !== undefined) {
            hasAnyValues = true;
            internalValueResult.externalTableDefinition = this._externalTableDefinition;
        }
        if (this._ignoreHeadersRow !== undefined) {
            hasAnyValues = true;
            internalValueResult.ignoreHeadersRow = this._ignoreHeadersRow;
        }
        if (this._includeOpForFullLoad !== undefined) {
            hasAnyValues = true;
            internalValueResult.includeOpForFullLoad = this._includeOpForFullLoad;
        }
        if (this._maxFileSize !== undefined) {
            hasAnyValues = true;
            internalValueResult.maxFileSize = this._maxFileSize;
        }
        if (this._parquetTimestampInMillisecond !== undefined) {
            hasAnyValues = true;
            internalValueResult.parquetTimestampInMillisecond = this._parquetTimestampInMillisecond;
        }
        if (this._parquetVersion !== undefined) {
            hasAnyValues = true;
            internalValueResult.parquetVersion = this._parquetVersion;
        }
        if (this._preserveTransactions !== undefined) {
            hasAnyValues = true;
            internalValueResult.preserveTransactions = this._preserveTransactions;
        }
        if (this._rfc4180 !== undefined) {
            hasAnyValues = true;
            internalValueResult.rfc4180 = this._rfc4180;
        }
        if (this._rowGroupLength !== undefined) {
            hasAnyValues = true;
            internalValueResult.rowGroupLength = this._rowGroupLength;
        }
        if (this._serverSideEncryptionKmsKeyId !== undefined) {
            hasAnyValues = true;
            internalValueResult.serverSideEncryptionKmsKeyId = this._serverSideEncryptionKmsKeyId;
        }
        if (this._serviceAccessRoleArn !== undefined) {
            hasAnyValues = true;
            internalValueResult.serviceAccessRoleArn = this._serviceAccessRoleArn;
        }
        if (this._timestampColumnName !== undefined) {
            hasAnyValues = true;
            internalValueResult.timestampColumnName = this._timestampColumnName;
        }
        if (this._useCsvNoSupValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.useCsvNoSupValue = this._useCsvNoSupValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._addColumnName = undefined;
            this._bucketFolder = undefined;
            this._bucketName = undefined;
            this._cannedAclForObjects = undefined;
            this._cdcInsertsAndUpdates = undefined;
            this._cdcInsertsOnly = undefined;
            this._cdcMaxBatchInterval = undefined;
            this._cdcMinFileSize = undefined;
            this._cdcPath = undefined;
            this._compressionType = undefined;
            this._csvDelimiter = undefined;
            this._csvNoSupValue = undefined;
            this._csvNullValue = undefined;
            this._csvRowDelimiter = undefined;
            this._dataFormat = undefined;
            this._dataPageSize = undefined;
            this._datePartitionDelimiter = undefined;
            this._datePartitionEnabled = undefined;
            this._datePartitionSequence = undefined;
            this._dictPageSizeLimit = undefined;
            this._enableStatistics = undefined;
            this._encodingType = undefined;
            this._encryptionMode = undefined;
            this._externalTableDefinition = undefined;
            this._ignoreHeadersRow = undefined;
            this._includeOpForFullLoad = undefined;
            this._maxFileSize = undefined;
            this._parquetTimestampInMillisecond = undefined;
            this._parquetVersion = undefined;
            this._preserveTransactions = undefined;
            this._rfc4180 = undefined;
            this._rowGroupLength = undefined;
            this._serverSideEncryptionKmsKeyId = undefined;
            this._serviceAccessRoleArn = undefined;
            this._timestampColumnName = undefined;
            this._useCsvNoSupValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._addColumnName = value.addColumnName;
            this._bucketFolder = value.bucketFolder;
            this._bucketName = value.bucketName;
            this._cannedAclForObjects = value.cannedAclForObjects;
            this._cdcInsertsAndUpdates = value.cdcInsertsAndUpdates;
            this._cdcInsertsOnly = value.cdcInsertsOnly;
            this._cdcMaxBatchInterval = value.cdcMaxBatchInterval;
            this._cdcMinFileSize = value.cdcMinFileSize;
            this._cdcPath = value.cdcPath;
            this._compressionType = value.compressionType;
            this._csvDelimiter = value.csvDelimiter;
            this._csvNoSupValue = value.csvNoSupValue;
            this._csvNullValue = value.csvNullValue;
            this._csvRowDelimiter = value.csvRowDelimiter;
            this._dataFormat = value.dataFormat;
            this._dataPageSize = value.dataPageSize;
            this._datePartitionDelimiter = value.datePartitionDelimiter;
            this._datePartitionEnabled = value.datePartitionEnabled;
            this._datePartitionSequence = value.datePartitionSequence;
            this._dictPageSizeLimit = value.dictPageSizeLimit;
            this._enableStatistics = value.enableStatistics;
            this._encodingType = value.encodingType;
            this._encryptionMode = value.encryptionMode;
            this._externalTableDefinition = value.externalTableDefinition;
            this._ignoreHeadersRow = value.ignoreHeadersRow;
            this._includeOpForFullLoad = value.includeOpForFullLoad;
            this._maxFileSize = value.maxFileSize;
            this._parquetTimestampInMillisecond = value.parquetTimestampInMillisecond;
            this._parquetVersion = value.parquetVersion;
            this._preserveTransactions = value.preserveTransactions;
            this._rfc4180 = value.rfc4180;
            this._rowGroupLength = value.rowGroupLength;
            this._serverSideEncryptionKmsKeyId = value.serverSideEncryptionKmsKeyId;
            this._serviceAccessRoleArn = value.serviceAccessRoleArn;
            this._timestampColumnName = value.timestampColumnName;
            this._useCsvNoSupValue = value.useCsvNoSupValue;
        }
    }
    get addColumnName() {
        return this.getBooleanAttribute('add_column_name');
    }
    set addColumnName(value) {
        this._addColumnName = value;
    }
    resetAddColumnName() {
        this._addColumnName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get addColumnNameInput() {
        return this._addColumnName;
    }
    get bucketFolder() {
        return this.getStringAttribute('bucket_folder');
    }
    set bucketFolder(value) {
        this._bucketFolder = value;
    }
    resetBucketFolder() {
        this._bucketFolder = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get bucketFolderInput() {
        return this._bucketFolder;
    }
    get bucketName() {
        return this.getStringAttribute('bucket_name');
    }
    set bucketName(value) {
        this._bucketName = value;
    }
    resetBucketName() {
        this._bucketName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get bucketNameInput() {
        return this._bucketName;
    }
    get cannedAclForObjects() {
        return this.getStringAttribute('canned_acl_for_objects');
    }
    set cannedAclForObjects(value) {
        this._cannedAclForObjects = value;
    }
    resetCannedAclForObjects() {
        this._cannedAclForObjects = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cannedAclForObjectsInput() {
        return this._cannedAclForObjects;
    }
    get cdcInsertsAndUpdates() {
        return this.getBooleanAttribute('cdc_inserts_and_updates');
    }
    set cdcInsertsAndUpdates(value) {
        this._cdcInsertsAndUpdates = value;
    }
    resetCdcInsertsAndUpdates() {
        this._cdcInsertsAndUpdates = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cdcInsertsAndUpdatesInput() {
        return this._cdcInsertsAndUpdates;
    }
    get cdcInsertsOnly() {
        return this.getBooleanAttribute('cdc_inserts_only');
    }
    set cdcInsertsOnly(value) {
        this._cdcInsertsOnly = value;
    }
    resetCdcInsertsOnly() {
        this._cdcInsertsOnly = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cdcInsertsOnlyInput() {
        return this._cdcInsertsOnly;
    }
    get cdcMaxBatchInterval() {
        return this.getNumberAttribute('cdc_max_batch_interval');
    }
    set cdcMaxBatchInterval(value) {
        this._cdcMaxBatchInterval = value;
    }
    resetCdcMaxBatchInterval() {
        this._cdcMaxBatchInterval = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cdcMaxBatchIntervalInput() {
        return this._cdcMaxBatchInterval;
    }
    get cdcMinFileSize() {
        return this.getNumberAttribute('cdc_min_file_size');
    }
    set cdcMinFileSize(value) {
        this._cdcMinFileSize = value;
    }
    resetCdcMinFileSize() {
        this._cdcMinFileSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cdcMinFileSizeInput() {
        return this._cdcMinFileSize;
    }
    get cdcPath() {
        return this.getStringAttribute('cdc_path');
    }
    set cdcPath(value) {
        this._cdcPath = value;
    }
    resetCdcPath() {
        this._cdcPath = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cdcPathInput() {
        return this._cdcPath;
    }
    get compressionType() {
        return this.getStringAttribute('compression_type');
    }
    set compressionType(value) {
        this._compressionType = value;
    }
    resetCompressionType() {
        this._compressionType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get compressionTypeInput() {
        return this._compressionType;
    }
    get csvDelimiter() {
        return this.getStringAttribute('csv_delimiter');
    }
    set csvDelimiter(value) {
        this._csvDelimiter = value;
    }
    resetCsvDelimiter() {
        this._csvDelimiter = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get csvDelimiterInput() {
        return this._csvDelimiter;
    }
    get csvNoSupValue() {
        return this.getStringAttribute('csv_no_sup_value');
    }
    set csvNoSupValue(value) {
        this._csvNoSupValue = value;
    }
    resetCsvNoSupValue() {
        this._csvNoSupValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get csvNoSupValueInput() {
        return this._csvNoSupValue;
    }
    get csvNullValue() {
        return this.getStringAttribute('csv_null_value');
    }
    set csvNullValue(value) {
        this._csvNullValue = value;
    }
    resetCsvNullValue() {
        this._csvNullValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get csvNullValueInput() {
        return this._csvNullValue;
    }
    get csvRowDelimiter() {
        return this.getStringAttribute('csv_row_delimiter');
    }
    set csvRowDelimiter(value) {
        this._csvRowDelimiter = value;
    }
    resetCsvRowDelimiter() {
        this._csvRowDelimiter = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get csvRowDelimiterInput() {
        return this._csvRowDelimiter;
    }
    get dataFormat() {
        return this.getStringAttribute('data_format');
    }
    set dataFormat(value) {
        this._dataFormat = value;
    }
    resetDataFormat() {
        this._dataFormat = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dataFormatInput() {
        return this._dataFormat;
    }
    get dataPageSize() {
        return this.getNumberAttribute('data_page_size');
    }
    set dataPageSize(value) {
        this._dataPageSize = value;
    }
    resetDataPageSize() {
        this._dataPageSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dataPageSizeInput() {
        return this._dataPageSize;
    }
    get datePartitionDelimiter() {
        return this.getStringAttribute('date_partition_delimiter');
    }
    set datePartitionDelimiter(value) {
        this._datePartitionDelimiter = value;
    }
    resetDatePartitionDelimiter() {
        this._datePartitionDelimiter = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get datePartitionDelimiterInput() {
        return this._datePartitionDelimiter;
    }
    get datePartitionEnabled() {
        return this.getBooleanAttribute('date_partition_enabled');
    }
    set datePartitionEnabled(value) {
        this._datePartitionEnabled = value;
    }
    resetDatePartitionEnabled() {
        this._datePartitionEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get datePartitionEnabledInput() {
        return this._datePartitionEnabled;
    }
    get datePartitionSequence() {
        return this.getStringAttribute('date_partition_sequence');
    }
    set datePartitionSequence(value) {
        this._datePartitionSequence = value;
    }
    resetDatePartitionSequence() {
        this._datePartitionSequence = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get datePartitionSequenceInput() {
        return this._datePartitionSequence;
    }
    get dictPageSizeLimit() {
        return this.getNumberAttribute('dict_page_size_limit');
    }
    set dictPageSizeLimit(value) {
        this._dictPageSizeLimit = value;
    }
    resetDictPageSizeLimit() {
        this._dictPageSizeLimit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dictPageSizeLimitInput() {
        return this._dictPageSizeLimit;
    }
    get enableStatistics() {
        return this.getBooleanAttribute('enable_statistics');
    }
    set enableStatistics(value) {
        this._enableStatistics = value;
    }
    resetEnableStatistics() {
        this._enableStatistics = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableStatisticsInput() {
        return this._enableStatistics;
    }
    get encodingType() {
        return this.getStringAttribute('encoding_type');
    }
    set encodingType(value) {
        this._encodingType = value;
    }
    resetEncodingType() {
        this._encodingType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get encodingTypeInput() {
        return this._encodingType;
    }
    get encryptionMode() {
        return this.getStringAttribute('encryption_mode');
    }
    set encryptionMode(value) {
        this._encryptionMode = value;
    }
    resetEncryptionMode() {
        this._encryptionMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get encryptionModeInput() {
        return this._encryptionMode;
    }
    get externalTableDefinition() {
        return this.getStringAttribute('external_table_definition');
    }
    set externalTableDefinition(value) {
        this._externalTableDefinition = value;
    }
    resetExternalTableDefinition() {
        this._externalTableDefinition = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get externalTableDefinitionInput() {
        return this._externalTableDefinition;
    }
    get ignoreHeadersRow() {
        return this.getNumberAttribute('ignore_headers_row');
    }
    set ignoreHeadersRow(value) {
        this._ignoreHeadersRow = value;
    }
    resetIgnoreHeadersRow() {
        this._ignoreHeadersRow = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ignoreHeadersRowInput() {
        return this._ignoreHeadersRow;
    }
    get includeOpForFullLoad() {
        return this.getBooleanAttribute('include_op_for_full_load');
    }
    set includeOpForFullLoad(value) {
        this._includeOpForFullLoad = value;
    }
    resetIncludeOpForFullLoad() {
        this._includeOpForFullLoad = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get includeOpForFullLoadInput() {
        return this._includeOpForFullLoad;
    }
    get maxFileSize() {
        return this.getNumberAttribute('max_file_size');
    }
    set maxFileSize(value) {
        this._maxFileSize = value;
    }
    resetMaxFileSize() {
        this._maxFileSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxFileSizeInput() {
        return this._maxFileSize;
    }
    get parquetTimestampInMillisecond() {
        return this.getBooleanAttribute('parquet_timestamp_in_millisecond');
    }
    set parquetTimestampInMillisecond(value) {
        this._parquetTimestampInMillisecond = value;
    }
    resetParquetTimestampInMillisecond() {
        this._parquetTimestampInMillisecond = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get parquetTimestampInMillisecondInput() {
        return this._parquetTimestampInMillisecond;
    }
    get parquetVersion() {
        return this.getStringAttribute('parquet_version');
    }
    set parquetVersion(value) {
        this._parquetVersion = value;
    }
    resetParquetVersion() {
        this._parquetVersion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get parquetVersionInput() {
        return this._parquetVersion;
    }
    get preserveTransactions() {
        return this.getBooleanAttribute('preserve_transactions');
    }
    set preserveTransactions(value) {
        this._preserveTransactions = value;
    }
    resetPreserveTransactions() {
        this._preserveTransactions = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get preserveTransactionsInput() {
        return this._preserveTransactions;
    }
    get rfc4180() {
        return this.getBooleanAttribute('rfc_4180');
    }
    set rfc4180(value) {
        this._rfc4180 = value;
    }
    resetRfc4180() {
        this._rfc4180 = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get rfc4180Input() {
        return this._rfc4180;
    }
    get rowGroupLength() {
        return this.getNumberAttribute('row_group_length');
    }
    set rowGroupLength(value) {
        this._rowGroupLength = value;
    }
    resetRowGroupLength() {
        this._rowGroupLength = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get rowGroupLengthInput() {
        return this._rowGroupLength;
    }
    get serverSideEncryptionKmsKeyId() {
        return this.getStringAttribute('server_side_encryption_kms_key_id');
    }
    set serverSideEncryptionKmsKeyId(value) {
        this._serverSideEncryptionKmsKeyId = value;
    }
    resetServerSideEncryptionKmsKeyId() {
        this._serverSideEncryptionKmsKeyId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get serverSideEncryptionKmsKeyIdInput() {
        return this._serverSideEncryptionKmsKeyId;
    }
    get serviceAccessRoleArn() {
        return this.getStringAttribute('service_access_role_arn');
    }
    set serviceAccessRoleArn(value) {
        this._serviceAccessRoleArn = value;
    }
    resetServiceAccessRoleArn() {
        this._serviceAccessRoleArn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get serviceAccessRoleArnInput() {
        return this._serviceAccessRoleArn;
    }
    get timestampColumnName() {
        return this.getStringAttribute('timestamp_column_name');
    }
    set timestampColumnName(value) {
        this._timestampColumnName = value;
    }
    resetTimestampColumnName() {
        this._timestampColumnName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timestampColumnNameInput() {
        return this._timestampColumnName;
    }
    get useCsvNoSupValue() {
        return this.getBooleanAttribute('use_csv_no_sup_value');
    }
    set useCsvNoSupValue(value) {
        this._useCsvNoSupValue = value;
    }
    resetUseCsvNoSupValue() {
        this._useCsvNoSupValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get useCsvNoSupValueInput() {
        return this._useCsvNoSupValue;
    }
}
exports.DmsEndpointS3SettingsOutputReference = DmsEndpointS3SettingsOutputReference;
_e = JSII_RTTI_SYMBOL_1;
DmsEndpointS3SettingsOutputReference[_e] = { fqn: "@cdktf/provider-aws.dms.DmsEndpointS3SettingsOutputReference", version: "7.0.64" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/dms_endpoint aws_dms_endpoint}
*/
class DmsEndpoint extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/dms_endpoint aws_dms_endpoint} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DmsEndpointConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_dms_endpoint',
            terraformGeneratorMetadata: {
                providerName: 'aws',
                providerVersion: '4.15.1',
                providerVersionConstraint: '~> 4.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        // elasticsearch_settings - computed: false, optional: true, required: false
        this._elasticsearchSettings = new DmsEndpointElasticsearchSettingsOutputReference(this, "elasticsearch_settings");
        // kafka_settings - computed: false, optional: true, required: false
        this._kafkaSettings = new DmsEndpointKafkaSettingsOutputReference(this, "kafka_settings");
        // kinesis_settings - computed: false, optional: true, required: false
        this._kinesisSettings = new DmsEndpointKinesisSettingsOutputReference(this, "kinesis_settings");
        // mongodb_settings - computed: false, optional: true, required: false
        this._mongodbSettings = new DmsEndpointMongodbSettingsOutputReference(this, "mongodb_settings");
        // s3_settings - computed: false, optional: true, required: false
        this._s3Settings = new DmsEndpointS3SettingsOutputReference(this, "s3_settings");
        this._certificateArn = config.certificateArn;
        this._databaseName = config.databaseName;
        this._endpointId = config.endpointId;
        this._endpointType = config.endpointType;
        this._engineName = config.engineName;
        this._extraConnectionAttributes = config.extraConnectionAttributes;
        this._kmsKeyArn = config.kmsKeyArn;
        this._password = config.password;
        this._port = config.port;
        this._secretsManagerAccessRoleArn = config.secretsManagerAccessRoleArn;
        this._secretsManagerArn = config.secretsManagerArn;
        this._serverName = config.serverName;
        this._serviceAccessRole = config.serviceAccessRole;
        this._sslMode = config.sslMode;
        this._tags = config.tags;
        this._tagsAll = config.tagsAll;
        this._username = config.username;
        this._elasticsearchSettings.internalValue = config.elasticsearchSettings;
        this._kafkaSettings.internalValue = config.kafkaSettings;
        this._kinesisSettings.internalValue = config.kinesisSettings;
        this._mongodbSettings.internalValue = config.mongodbSettings;
        this._s3Settings.internalValue = config.s3Settings;
    }
    get certificateArn() {
        return this.getStringAttribute('certificate_arn');
    }
    set certificateArn(value) {
        this._certificateArn = value;
    }
    resetCertificateArn() {
        this._certificateArn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get certificateArnInput() {
        return this._certificateArn;
    }
    get databaseName() {
        return this.getStringAttribute('database_name');
    }
    set databaseName(value) {
        this._databaseName = value;
    }
    resetDatabaseName() {
        this._databaseName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get databaseNameInput() {
        return this._databaseName;
    }
    // endpoint_arn - computed: true, optional: false, required: false
    get endpointArn() {
        return this.getStringAttribute('endpoint_arn');
    }
    get endpointId() {
        return this.getStringAttribute('endpoint_id');
    }
    set endpointId(value) {
        this._endpointId = value;
    }
    // Temporarily expose input value. Use with caution.
    get endpointIdInput() {
        return this._endpointId;
    }
    get endpointType() {
        return this.getStringAttribute('endpoint_type');
    }
    set endpointType(value) {
        this._endpointType = value;
    }
    // Temporarily expose input value. Use with caution.
    get endpointTypeInput() {
        return this._endpointType;
    }
    get engineName() {
        return this.getStringAttribute('engine_name');
    }
    set engineName(value) {
        this._engineName = value;
    }
    // Temporarily expose input value. Use with caution.
    get engineNameInput() {
        return this._engineName;
    }
    get extraConnectionAttributes() {
        return this.getStringAttribute('extra_connection_attributes');
    }
    set extraConnectionAttributes(value) {
        this._extraConnectionAttributes = value;
    }
    resetExtraConnectionAttributes() {
        this._extraConnectionAttributes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get extraConnectionAttributesInput() {
        return this._extraConnectionAttributes;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get kmsKeyArn() {
        return this.getStringAttribute('kms_key_arn');
    }
    set kmsKeyArn(value) {
        this._kmsKeyArn = value;
    }
    resetKmsKeyArn() {
        this._kmsKeyArn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get kmsKeyArnInput() {
        return this._kmsKeyArn;
    }
    get password() {
        return this.getStringAttribute('password');
    }
    set password(value) {
        this._password = value;
    }
    resetPassword() {
        this._password = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordInput() {
        return this._password;
    }
    get port() {
        return this.getNumberAttribute('port');
    }
    set port(value) {
        this._port = value;
    }
    resetPort() {
        this._port = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get portInput() {
        return this._port;
    }
    get secretsManagerAccessRoleArn() {
        return this.getStringAttribute('secrets_manager_access_role_arn');
    }
    set secretsManagerAccessRoleArn(value) {
        this._secretsManagerAccessRoleArn = value;
    }
    resetSecretsManagerAccessRoleArn() {
        this._secretsManagerAccessRoleArn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get secretsManagerAccessRoleArnInput() {
        return this._secretsManagerAccessRoleArn;
    }
    get secretsManagerArn() {
        return this.getStringAttribute('secrets_manager_arn');
    }
    set secretsManagerArn(value) {
        this._secretsManagerArn = value;
    }
    resetSecretsManagerArn() {
        this._secretsManagerArn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get secretsManagerArnInput() {
        return this._secretsManagerArn;
    }
    get serverName() {
        return this.getStringAttribute('server_name');
    }
    set serverName(value) {
        this._serverName = value;
    }
    resetServerName() {
        this._serverName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get serverNameInput() {
        return this._serverName;
    }
    get serviceAccessRole() {
        return this.getStringAttribute('service_access_role');
    }
    set serviceAccessRole(value) {
        this._serviceAccessRole = value;
    }
    resetServiceAccessRole() {
        this._serviceAccessRole = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get serviceAccessRoleInput() {
        return this._serviceAccessRole;
    }
    get sslMode() {
        return this.getStringAttribute('ssl_mode');
    }
    set sslMode(value) {
        this._sslMode = value;
    }
    resetSslMode() {
        this._sslMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sslModeInput() {
        return this._sslMode;
    }
    get tags() {
        return this.getStringMapAttribute('tags');
    }
    set tags(value) {
        this._tags = value;
    }
    resetTags() {
        this._tags = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsInput() {
        return this._tags;
    }
    get tagsAll() {
        return this.getStringMapAttribute('tags_all');
    }
    set tagsAll(value) {
        this._tagsAll = value;
    }
    resetTagsAll() {
        this._tagsAll = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsAllInput() {
        return this._tagsAll;
    }
    get username() {
        return this.getStringAttribute('username');
    }
    set username(value) {
        this._username = value;
    }
    resetUsername() {
        this._username = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get usernameInput() {
        return this._username;
    }
    get elasticsearchSettings() {
        return this._elasticsearchSettings;
    }
    putElasticsearchSettings(value) {
        this._elasticsearchSettings.internalValue = value;
    }
    resetElasticsearchSettings() {
        this._elasticsearchSettings.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get elasticsearchSettingsInput() {
        return this._elasticsearchSettings.internalValue;
    }
    get kafkaSettings() {
        return this._kafkaSettings;
    }
    putKafkaSettings(value) {
        this._kafkaSettings.internalValue = value;
    }
    resetKafkaSettings() {
        this._kafkaSettings.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get kafkaSettingsInput() {
        return this._kafkaSettings.internalValue;
    }
    get kinesisSettings() {
        return this._kinesisSettings;
    }
    putKinesisSettings(value) {
        this._kinesisSettings.internalValue = value;
    }
    resetKinesisSettings() {
        this._kinesisSettings.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get kinesisSettingsInput() {
        return this._kinesisSettings.internalValue;
    }
    get mongodbSettings() {
        return this._mongodbSettings;
    }
    putMongodbSettings(value) {
        this._mongodbSettings.internalValue = value;
    }
    resetMongodbSettings() {
        this._mongodbSettings.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mongodbSettingsInput() {
        return this._mongodbSettings.internalValue;
    }
    get s3Settings() {
        return this._s3Settings;
    }
    putS3Settings(value) {
        this._s3Settings.internalValue = value;
    }
    resetS3Settings() {
        this._s3Settings.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get s3SettingsInput() {
        return this._s3Settings.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            certificate_arn: cdktf.stringToTerraform(this._certificateArn),
            database_name: cdktf.stringToTerraform(this._databaseName),
            endpoint_id: cdktf.stringToTerraform(this._endpointId),
            endpoint_type: cdktf.stringToTerraform(this._endpointType),
            engine_name: cdktf.stringToTerraform(this._engineName),
            extra_connection_attributes: cdktf.stringToTerraform(this._extraConnectionAttributes),
            kms_key_arn: cdktf.stringToTerraform(this._kmsKeyArn),
            password: cdktf.stringToTerraform(this._password),
            port: cdktf.numberToTerraform(this._port),
            secrets_manager_access_role_arn: cdktf.stringToTerraform(this._secretsManagerAccessRoleArn),
            secrets_manager_arn: cdktf.stringToTerraform(this._secretsManagerArn),
            server_name: cdktf.stringToTerraform(this._serverName),
            service_access_role: cdktf.stringToTerraform(this._serviceAccessRole),
            ssl_mode: cdktf.stringToTerraform(this._sslMode),
            tags: cdktf.hashMapper(cdktf.stringToTerraform)(this._tags),
            tags_all: cdktf.hashMapper(cdktf.stringToTerraform)(this._tagsAll),
            username: cdktf.stringToTerraform(this._username),
            elasticsearch_settings: dmsEndpointElasticsearchSettingsToTerraform(this._elasticsearchSettings.internalValue),
            kafka_settings: dmsEndpointKafkaSettingsToTerraform(this._kafkaSettings.internalValue),
            kinesis_settings: dmsEndpointKinesisSettingsToTerraform(this._kinesisSettings.internalValue),
            mongodb_settings: dmsEndpointMongodbSettingsToTerraform(this._mongodbSettings.internalValue),
            s3_settings: dmsEndpointS3SettingsToTerraform(this._s3Settings.internalValue),
        };
    }
}
exports.DmsEndpoint = DmsEndpoint;
_f = JSII_RTTI_SYMBOL_1;
DmsEndpoint[_f] = { fqn: "@cdktf/provider-aws.dms.DmsEndpoint", version: "7.0.64" };
// =================
// STATIC PROPERTIES
// =================
DmsEndpoint.tfResourceType = "aws_dms_endpoint";
//# sourceMappingURL=data:application/json;base64,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