"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DmsReplicationTask = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/dms_replication_task aws_dms_replication_task}
*/
class DmsReplicationTask extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/dms_replication_task aws_dms_replication_task} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DmsReplicationTaskConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_dms_replication_task',
            terraformGeneratorMetadata: {
                providerName: 'aws',
                providerVersion: '4.15.1',
                providerVersionConstraint: '~> 4.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._cdcStartPosition = config.cdcStartPosition;
        this._cdcStartTime = config.cdcStartTime;
        this._migrationType = config.migrationType;
        this._replicationInstanceArn = config.replicationInstanceArn;
        this._replicationTaskId = config.replicationTaskId;
        this._replicationTaskSettings = config.replicationTaskSettings;
        this._sourceEndpointArn = config.sourceEndpointArn;
        this._startReplicationTask = config.startReplicationTask;
        this._tableMappings = config.tableMappings;
        this._tags = config.tags;
        this._tagsAll = config.tagsAll;
        this._targetEndpointArn = config.targetEndpointArn;
    }
    get cdcStartPosition() {
        return this.getStringAttribute('cdc_start_position');
    }
    set cdcStartPosition(value) {
        this._cdcStartPosition = value;
    }
    resetCdcStartPosition() {
        this._cdcStartPosition = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cdcStartPositionInput() {
        return this._cdcStartPosition;
    }
    get cdcStartTime() {
        return this.getStringAttribute('cdc_start_time');
    }
    set cdcStartTime(value) {
        this._cdcStartTime = value;
    }
    resetCdcStartTime() {
        this._cdcStartTime = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cdcStartTimeInput() {
        return this._cdcStartTime;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get migrationType() {
        return this.getStringAttribute('migration_type');
    }
    set migrationType(value) {
        this._migrationType = value;
    }
    // Temporarily expose input value. Use with caution.
    get migrationTypeInput() {
        return this._migrationType;
    }
    get replicationInstanceArn() {
        return this.getStringAttribute('replication_instance_arn');
    }
    set replicationInstanceArn(value) {
        this._replicationInstanceArn = value;
    }
    // Temporarily expose input value. Use with caution.
    get replicationInstanceArnInput() {
        return this._replicationInstanceArn;
    }
    // replication_task_arn - computed: true, optional: false, required: false
    get replicationTaskArn() {
        return this.getStringAttribute('replication_task_arn');
    }
    get replicationTaskId() {
        return this.getStringAttribute('replication_task_id');
    }
    set replicationTaskId(value) {
        this._replicationTaskId = value;
    }
    // Temporarily expose input value. Use with caution.
    get replicationTaskIdInput() {
        return this._replicationTaskId;
    }
    get replicationTaskSettings() {
        return this.getStringAttribute('replication_task_settings');
    }
    set replicationTaskSettings(value) {
        this._replicationTaskSettings = value;
    }
    resetReplicationTaskSettings() {
        this._replicationTaskSettings = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get replicationTaskSettingsInput() {
        return this._replicationTaskSettings;
    }
    get sourceEndpointArn() {
        return this.getStringAttribute('source_endpoint_arn');
    }
    set sourceEndpointArn(value) {
        this._sourceEndpointArn = value;
    }
    // Temporarily expose input value. Use with caution.
    get sourceEndpointArnInput() {
        return this._sourceEndpointArn;
    }
    get startReplicationTask() {
        return this.getBooleanAttribute('start_replication_task');
    }
    set startReplicationTask(value) {
        this._startReplicationTask = value;
    }
    resetStartReplicationTask() {
        this._startReplicationTask = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get startReplicationTaskInput() {
        return this._startReplicationTask;
    }
    // status - computed: true, optional: false, required: false
    get status() {
        return this.getStringAttribute('status');
    }
    get tableMappings() {
        return this.getStringAttribute('table_mappings');
    }
    set tableMappings(value) {
        this._tableMappings = value;
    }
    // Temporarily expose input value. Use with caution.
    get tableMappingsInput() {
        return this._tableMappings;
    }
    get tags() {
        return this.getStringMapAttribute('tags');
    }
    set tags(value) {
        this._tags = value;
    }
    resetTags() {
        this._tags = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsInput() {
        return this._tags;
    }
    get tagsAll() {
        return this.getStringMapAttribute('tags_all');
    }
    set tagsAll(value) {
        this._tagsAll = value;
    }
    resetTagsAll() {
        this._tagsAll = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsAllInput() {
        return this._tagsAll;
    }
    get targetEndpointArn() {
        return this.getStringAttribute('target_endpoint_arn');
    }
    set targetEndpointArn(value) {
        this._targetEndpointArn = value;
    }
    // Temporarily expose input value. Use with caution.
    get targetEndpointArnInput() {
        return this._targetEndpointArn;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            cdc_start_position: cdktf.stringToTerraform(this._cdcStartPosition),
            cdc_start_time: cdktf.stringToTerraform(this._cdcStartTime),
            migration_type: cdktf.stringToTerraform(this._migrationType),
            replication_instance_arn: cdktf.stringToTerraform(this._replicationInstanceArn),
            replication_task_id: cdktf.stringToTerraform(this._replicationTaskId),
            replication_task_settings: cdktf.stringToTerraform(this._replicationTaskSettings),
            source_endpoint_arn: cdktf.stringToTerraform(this._sourceEndpointArn),
            start_replication_task: cdktf.booleanToTerraform(this._startReplicationTask),
            table_mappings: cdktf.stringToTerraform(this._tableMappings),
            tags: cdktf.hashMapper(cdktf.stringToTerraform)(this._tags),
            tags_all: cdktf.hashMapper(cdktf.stringToTerraform)(this._tagsAll),
            target_endpoint_arn: cdktf.stringToTerraform(this._targetEndpointArn),
        };
    }
}
exports.DmsReplicationTask = DmsReplicationTask;
_a = JSII_RTTI_SYMBOL_1;
DmsReplicationTask[_a] = { fqn: "@cdktf/provider-aws.dms.DmsReplicationTask", version: "7.0.64" };
// =================
// STATIC PROPERTIES
// =================
DmsReplicationTask.tfResourceType = "aws_dms_replication_task";
//# sourceMappingURL=data:application/json;base64,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