import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS DynamoDB
*/
export interface DataAwsDynamodbTableConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/dynamodb_table#name DataAwsDynamodbTable#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/dynamodb_table#tags DataAwsDynamodbTable#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * server_side_encryption block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/dynamodb_table#server_side_encryption DataAwsDynamodbTable#server_side_encryption}
    */
    readonly serverSideEncryption?: DataAwsDynamodbTableServerSideEncryption;
}
export interface DataAwsDynamodbTableAttribute {
}
export declare function dataAwsDynamodbTableAttributeToTerraform(struct?: DataAwsDynamodbTableAttribute): any;
export declare class DataAwsDynamodbTableAttributeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsDynamodbTableAttribute | undefined;
    set internalValue(value: DataAwsDynamodbTableAttribute | undefined);
    get name(): string;
    get type(): string;
}
export declare class DataAwsDynamodbTableAttributeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsDynamodbTableAttributeOutputReference;
}
export interface DataAwsDynamodbTableGlobalSecondaryIndex {
}
export declare function dataAwsDynamodbTableGlobalSecondaryIndexToTerraform(struct?: DataAwsDynamodbTableGlobalSecondaryIndex): any;
export declare class DataAwsDynamodbTableGlobalSecondaryIndexOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsDynamodbTableGlobalSecondaryIndex | undefined;
    set internalValue(value: DataAwsDynamodbTableGlobalSecondaryIndex | undefined);
    get hashKey(): string;
    get name(): string;
    get nonKeyAttributes(): string[];
    get projectionType(): string;
    get rangeKey(): string;
    get readCapacity(): number;
    get writeCapacity(): number;
}
export declare class DataAwsDynamodbTableGlobalSecondaryIndexList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsDynamodbTableGlobalSecondaryIndexOutputReference;
}
export interface DataAwsDynamodbTableLocalSecondaryIndex {
}
export declare function dataAwsDynamodbTableLocalSecondaryIndexToTerraform(struct?: DataAwsDynamodbTableLocalSecondaryIndex): any;
export declare class DataAwsDynamodbTableLocalSecondaryIndexOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsDynamodbTableLocalSecondaryIndex | undefined;
    set internalValue(value: DataAwsDynamodbTableLocalSecondaryIndex | undefined);
    get name(): string;
    get nonKeyAttributes(): string[];
    get projectionType(): string;
    get rangeKey(): string;
}
export declare class DataAwsDynamodbTableLocalSecondaryIndexList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsDynamodbTableLocalSecondaryIndexOutputReference;
}
export interface DataAwsDynamodbTablePointInTimeRecovery {
}
export declare function dataAwsDynamodbTablePointInTimeRecoveryToTerraform(struct?: DataAwsDynamodbTablePointInTimeRecovery): any;
export declare class DataAwsDynamodbTablePointInTimeRecoveryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsDynamodbTablePointInTimeRecovery | undefined;
    set internalValue(value: DataAwsDynamodbTablePointInTimeRecovery | undefined);
    get enabled(): cdktf.IResolvable;
}
export declare class DataAwsDynamodbTablePointInTimeRecoveryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsDynamodbTablePointInTimeRecoveryOutputReference;
}
export interface DataAwsDynamodbTableReplica {
}
export declare function dataAwsDynamodbTableReplicaToTerraform(struct?: DataAwsDynamodbTableReplica): any;
export declare class DataAwsDynamodbTableReplicaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsDynamodbTableReplica | undefined;
    set internalValue(value: DataAwsDynamodbTableReplica | undefined);
    get kmsKeyArn(): string;
    get regionName(): string;
}
export declare class DataAwsDynamodbTableReplicaList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsDynamodbTableReplicaOutputReference;
}
export interface DataAwsDynamodbTableTtl {
}
export declare function dataAwsDynamodbTableTtlToTerraform(struct?: DataAwsDynamodbTableTtl): any;
export declare class DataAwsDynamodbTableTtlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsDynamodbTableTtl | undefined;
    set internalValue(value: DataAwsDynamodbTableTtl | undefined);
    get attributeName(): string;
    get enabled(): cdktf.IResolvable;
}
export declare class DataAwsDynamodbTableTtlList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsDynamodbTableTtlOutputReference;
}
export interface DataAwsDynamodbTableServerSideEncryption {
}
export declare function dataAwsDynamodbTableServerSideEncryptionToTerraform(struct?: DataAwsDynamodbTableServerSideEncryptionOutputReference | DataAwsDynamodbTableServerSideEncryption): any;
export declare class DataAwsDynamodbTableServerSideEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAwsDynamodbTableServerSideEncryption | undefined;
    set internalValue(value: DataAwsDynamodbTableServerSideEncryption | undefined);
    get enabled(): cdktf.IResolvable;
    get kmsKeyArn(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/dynamodb_table aws_dynamodb_table}
*/
export declare class DataAwsDynamodbTable extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_dynamodb_table";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/dynamodb_table aws_dynamodb_table} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsDynamodbTableConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsDynamodbTableConfig);
    get arn(): string;
    private _attribute;
    get attribute(): DataAwsDynamodbTableAttributeList;
    get billingMode(): string;
    private _globalSecondaryIndex;
    get globalSecondaryIndex(): DataAwsDynamodbTableGlobalSecondaryIndexList;
    get hashKey(): string;
    get id(): string;
    private _localSecondaryIndex;
    get localSecondaryIndex(): DataAwsDynamodbTableLocalSecondaryIndexList;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _pointInTimeRecovery;
    get pointInTimeRecovery(): DataAwsDynamodbTablePointInTimeRecoveryList;
    get rangeKey(): string;
    get readCapacity(): number;
    private _replica;
    get replica(): DataAwsDynamodbTableReplicaList;
    get streamArn(): string;
    get streamEnabled(): cdktf.IResolvable;
    get streamLabel(): string;
    get streamViewType(): string;
    get tableClass(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _ttl;
    get ttl(): DataAwsDynamodbTableTtlList;
    get writeCapacity(): number;
    private _serverSideEncryption;
    get serverSideEncryption(): DataAwsDynamodbTableServerSideEncryptionOutputReference;
    putServerSideEncryption(value: DataAwsDynamodbTableServerSideEncryption): void;
    resetServerSideEncryption(): void;
    get serverSideEncryptionInput(): DataAwsDynamodbTableServerSideEncryption | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-dynamodb-table.d.ts.map