import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS DynamoDB
*/
export interface DynamodbContributorInsightsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_contributor_insights#index_name DynamodbContributorInsights#index_name}
    */
    readonly indexName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_contributor_insights#table_name DynamodbContributorInsights#table_name}
    */
    readonly tableName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_contributor_insights#timeouts DynamodbContributorInsights#timeouts}
    */
    readonly timeouts?: DynamodbContributorInsightsTimeouts;
}
export interface DynamodbContributorInsightsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_contributor_insights#create DynamodbContributorInsights#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_contributor_insights#delete DynamodbContributorInsights#delete}
    */
    readonly delete?: string;
}
export declare function dynamodbContributorInsightsTimeoutsToTerraform(struct?: DynamodbContributorInsightsTimeoutsOutputReference | DynamodbContributorInsightsTimeouts | cdktf.IResolvable): any;
export declare class DynamodbContributorInsightsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DynamodbContributorInsightsTimeouts | undefined;
    set internalValue(value: DynamodbContributorInsightsTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_contributor_insights aws_dynamodb_contributor_insights}
*/
export declare class DynamodbContributorInsights extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_dynamodb_contributor_insights";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_contributor_insights aws_dynamodb_contributor_insights} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DynamodbContributorInsightsConfig
    */
    constructor(scope: Construct, id: string, config: DynamodbContributorInsightsConfig);
    get id(): string;
    private _indexName?;
    get indexName(): string;
    set indexName(value: string);
    resetIndexName(): void;
    get indexNameInput(): string | undefined;
    private _tableName?;
    get tableName(): string;
    set tableName(value: string);
    get tableNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DynamodbContributorInsightsTimeoutsOutputReference;
    putTimeouts(value: DynamodbContributorInsightsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DynamodbContributorInsightsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=dynamodb-contributor-insights.d.ts.map