import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS DynamoDB
*/
export interface DynamodbKinesisStreamingDestinationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_kinesis_streaming_destination#stream_arn DynamodbKinesisStreamingDestination#stream_arn}
    */
    readonly streamArn: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_kinesis_streaming_destination#table_name DynamodbKinesisStreamingDestination#table_name}
    */
    readonly tableName: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_kinesis_streaming_destination aws_dynamodb_kinesis_streaming_destination}
*/
export declare class DynamodbKinesisStreamingDestination extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_dynamodb_kinesis_streaming_destination";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_kinesis_streaming_destination aws_dynamodb_kinesis_streaming_destination} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DynamodbKinesisStreamingDestinationConfig
    */
    constructor(scope: Construct, id: string, config: DynamodbKinesisStreamingDestinationConfig);
    get id(): string;
    private _streamArn?;
    get streamArn(): string;
    set streamArn(value: string);
    get streamArnInput(): string | undefined;
    private _tableName?;
    get tableName(): string;
    set tableName(value: string);
    get tableNameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=dynamodb-kinesis-streaming-destination.d.ts.map