import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS DynamoDB
*/
export interface DynamodbTableConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_table#billing_mode DynamodbTable#billing_mode}
    */
    readonly billingMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_table#hash_key DynamodbTable#hash_key}
    */
    readonly hashKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_table#name DynamodbTable#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_table#range_key DynamodbTable#range_key}
    */
    readonly rangeKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_table#read_capacity DynamodbTable#read_capacity}
    */
    readonly readCapacity?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_table#restore_date_time DynamodbTable#restore_date_time}
    */
    readonly restoreDateTime?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_table#restore_source_name DynamodbTable#restore_source_name}
    */
    readonly restoreSourceName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_table#restore_to_latest_time DynamodbTable#restore_to_latest_time}
    */
    readonly restoreToLatestTime?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_table#stream_enabled DynamodbTable#stream_enabled}
    */
    readonly streamEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_table#stream_view_type DynamodbTable#stream_view_type}
    */
    readonly streamViewType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_table#table_class DynamodbTable#table_class}
    */
    readonly tableClass?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_table#tags DynamodbTable#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_table#tags_all DynamodbTable#tags_all}
    */
    readonly tagsAll?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_table#write_capacity DynamodbTable#write_capacity}
    */
    readonly writeCapacity?: number;
    /**
    * attribute block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_table#attribute DynamodbTable#attribute}
    */
    readonly attribute?: DynamodbTableAttribute[] | cdktf.IResolvable;
    /**
    * global_secondary_index block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_table#global_secondary_index DynamodbTable#global_secondary_index}
    */
    readonly globalSecondaryIndex?: DynamodbTableGlobalSecondaryIndex[] | cdktf.IResolvable;
    /**
    * local_secondary_index block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_table#local_secondary_index DynamodbTable#local_secondary_index}
    */
    readonly localSecondaryIndex?: DynamodbTableLocalSecondaryIndex[] | cdktf.IResolvable;
    /**
    * point_in_time_recovery block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_table#point_in_time_recovery DynamodbTable#point_in_time_recovery}
    */
    readonly pointInTimeRecovery?: DynamodbTablePointInTimeRecovery;
    /**
    * replica block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_table#replica DynamodbTable#replica}
    */
    readonly replica?: DynamodbTableReplica[] | cdktf.IResolvable;
    /**
    * server_side_encryption block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_table#server_side_encryption DynamodbTable#server_side_encryption}
    */
    readonly serverSideEncryption?: DynamodbTableServerSideEncryption;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_table#timeouts DynamodbTable#timeouts}
    */
    readonly timeouts?: DynamodbTableTimeouts;
    /**
    * ttl block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_table#ttl DynamodbTable#ttl}
    */
    readonly ttl?: DynamodbTableTtl;
}
export interface DynamodbTableAttribute {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_table#name DynamodbTable#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_table#type DynamodbTable#type}
    */
    readonly type: string;
}
export declare function dynamodbTableAttributeToTerraform(struct?: DynamodbTableAttribute | cdktf.IResolvable): any;
export interface DynamodbTableGlobalSecondaryIndex {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_table#hash_key DynamodbTable#hash_key}
    */
    readonly hashKey: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_table#name DynamodbTable#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_table#non_key_attributes DynamodbTable#non_key_attributes}
    */
    readonly nonKeyAttributes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_table#projection_type DynamodbTable#projection_type}
    */
    readonly projectionType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_table#range_key DynamodbTable#range_key}
    */
    readonly rangeKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_table#read_capacity DynamodbTable#read_capacity}
    */
    readonly readCapacity?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_table#write_capacity DynamodbTable#write_capacity}
    */
    readonly writeCapacity?: number;
}
export declare function dynamodbTableGlobalSecondaryIndexToTerraform(struct?: DynamodbTableGlobalSecondaryIndex | cdktf.IResolvable): any;
export interface DynamodbTableLocalSecondaryIndex {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_table#name DynamodbTable#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_table#non_key_attributes DynamodbTable#non_key_attributes}
    */
    readonly nonKeyAttributes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_table#projection_type DynamodbTable#projection_type}
    */
    readonly projectionType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_table#range_key DynamodbTable#range_key}
    */
    readonly rangeKey: string;
}
export declare function dynamodbTableLocalSecondaryIndexToTerraform(struct?: DynamodbTableLocalSecondaryIndex | cdktf.IResolvable): any;
export interface DynamodbTablePointInTimeRecovery {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_table#enabled DynamodbTable#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function dynamodbTablePointInTimeRecoveryToTerraform(struct?: DynamodbTablePointInTimeRecoveryOutputReference | DynamodbTablePointInTimeRecovery): any;
export declare class DynamodbTablePointInTimeRecoveryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DynamodbTablePointInTimeRecovery | undefined;
    set internalValue(value: DynamodbTablePointInTimeRecovery | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface DynamodbTableReplica {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_table#kms_key_arn DynamodbTable#kms_key_arn}
    */
    readonly kmsKeyArn?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_table#region_name DynamodbTable#region_name}
    */
    readonly regionName: string;
}
export declare function dynamodbTableReplicaToTerraform(struct?: DynamodbTableReplica | cdktf.IResolvable): any;
export interface DynamodbTableServerSideEncryption {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_table#enabled DynamodbTable#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_table#kms_key_arn DynamodbTable#kms_key_arn}
    */
    readonly kmsKeyArn?: string;
}
export declare function dynamodbTableServerSideEncryptionToTerraform(struct?: DynamodbTableServerSideEncryptionOutputReference | DynamodbTableServerSideEncryption): any;
export declare class DynamodbTableServerSideEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DynamodbTableServerSideEncryption | undefined;
    set internalValue(value: DynamodbTableServerSideEncryption | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _kmsKeyArn?;
    get kmsKeyArn(): string;
    set kmsKeyArn(value: string);
    resetKmsKeyArn(): void;
    get kmsKeyArnInput(): string | undefined;
}
export interface DynamodbTableTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_table#create DynamodbTable#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_table#delete DynamodbTable#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_table#update DynamodbTable#update}
    */
    readonly update?: string;
}
export declare function dynamodbTableTimeoutsToTerraform(struct?: DynamodbTableTimeoutsOutputReference | DynamodbTableTimeouts | cdktf.IResolvable): any;
export declare class DynamodbTableTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DynamodbTableTimeouts | undefined;
    set internalValue(value: DynamodbTableTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface DynamodbTableTtl {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_table#attribute_name DynamodbTable#attribute_name}
    */
    readonly attributeName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_table#enabled DynamodbTable#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function dynamodbTableTtlToTerraform(struct?: DynamodbTableTtlOutputReference | DynamodbTableTtl): any;
export declare class DynamodbTableTtlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DynamodbTableTtl | undefined;
    set internalValue(value: DynamodbTableTtl | undefined);
    private _attributeName?;
    get attributeName(): string;
    set attributeName(value: string);
    get attributeNameInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_table aws_dynamodb_table}
*/
export declare class DynamodbTable extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_dynamodb_table";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/dynamodb_table aws_dynamodb_table} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DynamodbTableConfig
    */
    constructor(scope: Construct, id: string, config: DynamodbTableConfig);
    get arn(): string;
    private _billingMode?;
    get billingMode(): string;
    set billingMode(value: string);
    resetBillingMode(): void;
    get billingModeInput(): string | undefined;
    private _hashKey?;
    get hashKey(): string;
    set hashKey(value: string);
    resetHashKey(): void;
    get hashKeyInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _rangeKey?;
    get rangeKey(): string;
    set rangeKey(value: string);
    resetRangeKey(): void;
    get rangeKeyInput(): string | undefined;
    private _readCapacity?;
    get readCapacity(): number;
    set readCapacity(value: number);
    resetReadCapacity(): void;
    get readCapacityInput(): number | undefined;
    private _restoreDateTime?;
    get restoreDateTime(): string;
    set restoreDateTime(value: string);
    resetRestoreDateTime(): void;
    get restoreDateTimeInput(): string | undefined;
    private _restoreSourceName?;
    get restoreSourceName(): string;
    set restoreSourceName(value: string);
    resetRestoreSourceName(): void;
    get restoreSourceNameInput(): string | undefined;
    private _restoreToLatestTime?;
    get restoreToLatestTime(): boolean | cdktf.IResolvable;
    set restoreToLatestTime(value: boolean | cdktf.IResolvable);
    resetRestoreToLatestTime(): void;
    get restoreToLatestTimeInput(): boolean | cdktf.IResolvable | undefined;
    get streamArn(): string;
    private _streamEnabled?;
    get streamEnabled(): boolean | cdktf.IResolvable;
    set streamEnabled(value: boolean | cdktf.IResolvable);
    resetStreamEnabled(): void;
    get streamEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get streamLabel(): string;
    private _streamViewType?;
    get streamViewType(): string;
    set streamViewType(value: string);
    resetStreamViewType(): void;
    get streamViewTypeInput(): string | undefined;
    private _tableClass?;
    get tableClass(): string;
    set tableClass(value: string);
    resetTableClass(): void;
    get tableClassInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tagsAll?;
    get tagsAll(): {
        [key: string]: string;
    };
    set tagsAll(value: {
        [key: string]: string;
    });
    resetTagsAll(): void;
    get tagsAllInput(): {
        [key: string]: string;
    } | undefined;
    private _writeCapacity?;
    get writeCapacity(): number;
    set writeCapacity(value: number);
    resetWriteCapacity(): void;
    get writeCapacityInput(): number | undefined;
    private _attribute?;
    get attribute(): DynamodbTableAttribute[] | cdktf.IResolvable;
    set attribute(value: DynamodbTableAttribute[] | cdktf.IResolvable);
    resetAttribute(): void;
    get attributeInput(): cdktf.IResolvable | DynamodbTableAttribute[] | undefined;
    private _globalSecondaryIndex?;
    get globalSecondaryIndex(): DynamodbTableGlobalSecondaryIndex[] | cdktf.IResolvable;
    set globalSecondaryIndex(value: DynamodbTableGlobalSecondaryIndex[] | cdktf.IResolvable);
    resetGlobalSecondaryIndex(): void;
    get globalSecondaryIndexInput(): cdktf.IResolvable | DynamodbTableGlobalSecondaryIndex[] | undefined;
    private _localSecondaryIndex?;
    get localSecondaryIndex(): DynamodbTableLocalSecondaryIndex[] | cdktf.IResolvable;
    set localSecondaryIndex(value: DynamodbTableLocalSecondaryIndex[] | cdktf.IResolvable);
    resetLocalSecondaryIndex(): void;
    get localSecondaryIndexInput(): cdktf.IResolvable | DynamodbTableLocalSecondaryIndex[] | undefined;
    private _pointInTimeRecovery;
    get pointInTimeRecovery(): DynamodbTablePointInTimeRecoveryOutputReference;
    putPointInTimeRecovery(value: DynamodbTablePointInTimeRecovery): void;
    resetPointInTimeRecovery(): void;
    get pointInTimeRecoveryInput(): DynamodbTablePointInTimeRecovery | undefined;
    private _replica?;
    get replica(): DynamodbTableReplica[] | cdktf.IResolvable;
    set replica(value: DynamodbTableReplica[] | cdktf.IResolvable);
    resetReplica(): void;
    get replicaInput(): cdktf.IResolvable | DynamodbTableReplica[] | undefined;
    private _serverSideEncryption;
    get serverSideEncryption(): DynamodbTableServerSideEncryptionOutputReference;
    putServerSideEncryption(value: DynamodbTableServerSideEncryption): void;
    resetServerSideEncryption(): void;
    get serverSideEncryptionInput(): DynamodbTableServerSideEncryption | undefined;
    private _timeouts;
    get timeouts(): DynamodbTableTimeoutsOutputReference;
    putTimeouts(value: DynamodbTableTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DynamodbTableTimeouts | undefined;
    private _ttl;
    get ttl(): DynamodbTableTtlOutputReference;
    putTtl(value: DynamodbTableTtl): void;
    resetTtl(): void;
    get ttlInput(): DynamodbTableTtl | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=dynamodb-table.d.ts.map