import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS EC2
*/
export interface DataAwsAmiConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ami#executable_users DataAwsAmi#executable_users}
    */
    readonly executableUsers?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ami#most_recent DataAwsAmi#most_recent}
    */
    readonly mostRecent?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ami#name_regex DataAwsAmi#name_regex}
    */
    readonly nameRegex?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ami#owners DataAwsAmi#owners}
    */
    readonly owners: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ami#tags DataAwsAmi#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ami#filter DataAwsAmi#filter}
    */
    readonly filter?: DataAwsAmiFilter[] | cdktf.IResolvable;
}
export interface DataAwsAmiBlockDeviceMappings {
}
export declare function dataAwsAmiBlockDeviceMappingsToTerraform(struct?: DataAwsAmiBlockDeviceMappings): any;
export declare class DataAwsAmiBlockDeviceMappingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsAmiBlockDeviceMappings | undefined;
    set internalValue(value: DataAwsAmiBlockDeviceMappings | undefined);
    get deviceName(): string;
    ebs(key: string): string | cdktf.IResolvable;
    get noDevice(): string;
    get virtualName(): string;
}
export declare class DataAwsAmiBlockDeviceMappingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsAmiBlockDeviceMappingsOutputReference;
}
export interface DataAwsAmiProductCodes {
}
export declare function dataAwsAmiProductCodesToTerraform(struct?: DataAwsAmiProductCodes): any;
export declare class DataAwsAmiProductCodesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsAmiProductCodes | undefined;
    set internalValue(value: DataAwsAmiProductCodes | undefined);
    get productCodeId(): string;
    get productCodeType(): string;
}
export declare class DataAwsAmiProductCodesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsAmiProductCodesOutputReference;
}
export interface DataAwsAmiFilter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ami#name DataAwsAmi#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ami#values DataAwsAmi#values}
    */
    readonly values: string[];
}
export declare function dataAwsAmiFilterToTerraform(struct?: DataAwsAmiFilter | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/ami aws_ami}
*/
export declare class DataAwsAmi extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_ami";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/ami aws_ami} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsAmiConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsAmiConfig);
    get architecture(): string;
    get arn(): string;
    private _blockDeviceMappings;
    get blockDeviceMappings(): DataAwsAmiBlockDeviceMappingsList;
    get bootMode(): string;
    get creationDate(): string;
    get deprecationTime(): string;
    get description(): string;
    get enaSupport(): cdktf.IResolvable;
    private _executableUsers?;
    get executableUsers(): string[];
    set executableUsers(value: string[]);
    resetExecutableUsers(): void;
    get executableUsersInput(): string[] | undefined;
    get hypervisor(): string;
    get id(): string;
    get imageId(): string;
    get imageLocation(): string;
    get imageOwnerAlias(): string;
    get imageType(): string;
    get kernelId(): string;
    private _mostRecent?;
    get mostRecent(): boolean | cdktf.IResolvable;
    set mostRecent(value: boolean | cdktf.IResolvable);
    resetMostRecent(): void;
    get mostRecentInput(): boolean | cdktf.IResolvable | undefined;
    get name(): string;
    private _nameRegex?;
    get nameRegex(): string;
    set nameRegex(value: string);
    resetNameRegex(): void;
    get nameRegexInput(): string | undefined;
    get ownerId(): string;
    private _owners?;
    get owners(): string[];
    set owners(value: string[]);
    get ownersInput(): string[] | undefined;
    get platform(): string;
    get platformDetails(): string;
    private _productCodes;
    get productCodes(): DataAwsAmiProductCodesList;
    get public(): cdktf.IResolvable;
    get ramdiskId(): string;
    get rootDeviceName(): string;
    get rootDeviceType(): string;
    get rootSnapshotId(): string;
    get sriovNetSupport(): string;
    get state(): string;
    stateReason(key: string): string | cdktf.IResolvable;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get usageOperation(): string;
    get virtualizationType(): string;
    private _filter?;
    get filter(): DataAwsAmiFilter[] | cdktf.IResolvable;
    set filter(value: DataAwsAmiFilter[] | cdktf.IResolvable);
    resetFilter(): void;
    get filterInput(): cdktf.IResolvable | DataAwsAmiFilter[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-ami.d.ts.map