import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS EC2
*/
export interface DataAwsEc2InstanceTypeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ec2_instance_type#default_cores DataAwsEc2InstanceType#default_cores}
    */
    readonly defaultCores?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ec2_instance_type#default_threads_per_core DataAwsEc2InstanceType#default_threads_per_core}
    */
    readonly defaultThreadsPerCore?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ec2_instance_type#hypervisor DataAwsEc2InstanceType#hypervisor}
    */
    readonly hypervisor?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ec2_instance_type#instance_type DataAwsEc2InstanceType#instance_type}
    */
    readonly instanceType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ec2_instance_type#maximum_ipv6_addresses_per_interface DataAwsEc2InstanceType#maximum_ipv6_addresses_per_interface}
    */
    readonly maximumIpv6AddressesPerInterface?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ec2_instance_type#total_fpga_memory DataAwsEc2InstanceType#total_fpga_memory}
    */
    readonly totalFpgaMemory?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ec2_instance_type#total_gpu_memory DataAwsEc2InstanceType#total_gpu_memory}
    */
    readonly totalGpuMemory?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ec2_instance_type#total_instance_storage DataAwsEc2InstanceType#total_instance_storage}
    */
    readonly totalInstanceStorage?: number;
    /**
    * fpgas block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ec2_instance_type#fpgas DataAwsEc2InstanceType#fpgas}
    */
    readonly fpgas?: DataAwsEc2InstanceTypeFpgas[] | cdktf.IResolvable;
    /**
    * gpus block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ec2_instance_type#gpus DataAwsEc2InstanceType#gpus}
    */
    readonly gpus?: DataAwsEc2InstanceTypeGpus[] | cdktf.IResolvable;
    /**
    * inference_accelerators block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ec2_instance_type#inference_accelerators DataAwsEc2InstanceType#inference_accelerators}
    */
    readonly inferenceAccelerators?: DataAwsEc2InstanceTypeInferenceAccelerators[] | cdktf.IResolvable;
    /**
    * instance_disks block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ec2_instance_type#instance_disks DataAwsEc2InstanceType#instance_disks}
    */
    readonly instanceDisks?: DataAwsEc2InstanceTypeInstanceDisks[] | cdktf.IResolvable;
}
export interface DataAwsEc2InstanceTypeFpgas {
}
export declare function dataAwsEc2InstanceTypeFpgasToTerraform(struct?: DataAwsEc2InstanceTypeFpgas | cdktf.IResolvable): any;
export interface DataAwsEc2InstanceTypeGpus {
}
export declare function dataAwsEc2InstanceTypeGpusToTerraform(struct?: DataAwsEc2InstanceTypeGpus | cdktf.IResolvable): any;
export interface DataAwsEc2InstanceTypeInferenceAccelerators {
}
export declare function dataAwsEc2InstanceTypeInferenceAcceleratorsToTerraform(struct?: DataAwsEc2InstanceTypeInferenceAccelerators | cdktf.IResolvable): any;
export interface DataAwsEc2InstanceTypeInstanceDisks {
}
export declare function dataAwsEc2InstanceTypeInstanceDisksToTerraform(struct?: DataAwsEc2InstanceTypeInstanceDisks | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/ec2_instance_type aws_ec2_instance_type}
*/
export declare class DataAwsEc2InstanceType extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_ec2_instance_type";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/ec2_instance_type aws_ec2_instance_type} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsEc2InstanceTypeConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsEc2InstanceTypeConfig);
    get autoRecoverySupported(): cdktf.IResolvable;
    get bareMetal(): cdktf.IResolvable;
    get burstablePerformanceSupported(): cdktf.IResolvable;
    get currentGeneration(): cdktf.IResolvable;
    get dedicatedHostsSupported(): cdktf.IResolvable;
    private _defaultCores?;
    get defaultCores(): number;
    set defaultCores(value: number);
    resetDefaultCores(): void;
    get defaultCoresInput(): number | undefined;
    private _defaultThreadsPerCore?;
    get defaultThreadsPerCore(): number;
    set defaultThreadsPerCore(value: number);
    resetDefaultThreadsPerCore(): void;
    get defaultThreadsPerCoreInput(): number | undefined;
    get defaultVcpus(): number;
    get ebsEncryptionSupport(): string;
    get ebsNvmeSupport(): string;
    get ebsOptimizedSupport(): string;
    get ebsPerformanceBaselineBandwidth(): number;
    get ebsPerformanceBaselineIops(): number;
    get ebsPerformanceBaselineThroughput(): number;
    get ebsPerformanceMaximumBandwidth(): number;
    get ebsPerformanceMaximumIops(): number;
    get ebsPerformanceMaximumThroughput(): number;
    get efaSupported(): cdktf.IResolvable;
    get enaSupport(): string;
    get encryptionInTransitSupported(): cdktf.IResolvable;
    get freeTierEligible(): cdktf.IResolvable;
    get hibernationSupported(): cdktf.IResolvable;
    private _hypervisor?;
    get hypervisor(): string;
    set hypervisor(value: string);
    resetHypervisor(): void;
    get hypervisorInput(): string | undefined;
    get id(): string;
    get instanceStorageSupported(): cdktf.IResolvable;
    private _instanceType?;
    get instanceType(): string;
    set instanceType(value: string);
    get instanceTypeInput(): string | undefined;
    get ipv6Supported(): cdktf.IResolvable;
    get maximumIpv4AddressesPerInterface(): number;
    private _maximumIpv6AddressesPerInterface?;
    get maximumIpv6AddressesPerInterface(): number;
    set maximumIpv6AddressesPerInterface(value: number);
    resetMaximumIpv6AddressesPerInterface(): void;
    get maximumIpv6AddressesPerInterfaceInput(): number | undefined;
    get maximumNetworkInterfaces(): number;
    get memorySize(): number;
    get networkPerformance(): string;
    get supportedArchitectures(): string[];
    get supportedPlacementStrategies(): string[];
    get supportedRootDeviceTypes(): string[];
    get supportedUsagesClasses(): string[];
    get supportedVirtualizationTypes(): string[];
    get sustainedClockSpeed(): number;
    private _totalFpgaMemory?;
    get totalFpgaMemory(): number;
    set totalFpgaMemory(value: number);
    resetTotalFpgaMemory(): void;
    get totalFpgaMemoryInput(): number | undefined;
    private _totalGpuMemory?;
    get totalGpuMemory(): number;
    set totalGpuMemory(value: number);
    resetTotalGpuMemory(): void;
    get totalGpuMemoryInput(): number | undefined;
    private _totalInstanceStorage?;
    get totalInstanceStorage(): number;
    set totalInstanceStorage(value: number);
    resetTotalInstanceStorage(): void;
    get totalInstanceStorageInput(): number | undefined;
    get validCores(): number[];
    get validThreadsPerCore(): number[];
    private _fpgas?;
    get fpgas(): DataAwsEc2InstanceTypeFpgas[] | cdktf.IResolvable;
    set fpgas(value: DataAwsEc2InstanceTypeFpgas[] | cdktf.IResolvable);
    resetFpgas(): void;
    get fpgasInput(): cdktf.IResolvable | DataAwsEc2InstanceTypeFpgas[] | undefined;
    private _gpus?;
    get gpus(): DataAwsEc2InstanceTypeGpus[] | cdktf.IResolvable;
    set gpus(value: DataAwsEc2InstanceTypeGpus[] | cdktf.IResolvable);
    resetGpus(): void;
    get gpusInput(): cdktf.IResolvable | DataAwsEc2InstanceTypeGpus[] | undefined;
    private _inferenceAccelerators?;
    get inferenceAccelerators(): DataAwsEc2InstanceTypeInferenceAccelerators[] | cdktf.IResolvable;
    set inferenceAccelerators(value: DataAwsEc2InstanceTypeInferenceAccelerators[] | cdktf.IResolvable);
    resetInferenceAccelerators(): void;
    get inferenceAcceleratorsInput(): cdktf.IResolvable | DataAwsEc2InstanceTypeInferenceAccelerators[] | undefined;
    private _instanceDisks?;
    get instanceDisks(): DataAwsEc2InstanceTypeInstanceDisks[] | cdktf.IResolvable;
    set instanceDisks(value: DataAwsEc2InstanceTypeInstanceDisks[] | cdktf.IResolvable);
    resetInstanceDisks(): void;
    get instanceDisksInput(): cdktf.IResolvable | DataAwsEc2InstanceTypeInstanceDisks[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-ec2-instance-type.d.ts.map