"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataAwsEc2InstanceType = exports.dataAwsEc2InstanceTypeInstanceDisksToTerraform = exports.dataAwsEc2InstanceTypeInferenceAcceleratorsToTerraform = exports.dataAwsEc2InstanceTypeGpusToTerraform = exports.dataAwsEc2InstanceTypeFpgasToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function dataAwsEc2InstanceTypeFpgasToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {};
}
exports.dataAwsEc2InstanceTypeFpgasToTerraform = dataAwsEc2InstanceTypeFpgasToTerraform;
function dataAwsEc2InstanceTypeGpusToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {};
}
exports.dataAwsEc2InstanceTypeGpusToTerraform = dataAwsEc2InstanceTypeGpusToTerraform;
function dataAwsEc2InstanceTypeInferenceAcceleratorsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {};
}
exports.dataAwsEc2InstanceTypeInferenceAcceleratorsToTerraform = dataAwsEc2InstanceTypeInferenceAcceleratorsToTerraform;
function dataAwsEc2InstanceTypeInstanceDisksToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {};
}
exports.dataAwsEc2InstanceTypeInstanceDisksToTerraform = dataAwsEc2InstanceTypeInstanceDisksToTerraform;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/ec2_instance_type aws_ec2_instance_type}
*/
class DataAwsEc2InstanceType extends cdktf.TerraformDataSource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/ec2_instance_type aws_ec2_instance_type} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsEc2InstanceTypeConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_ec2_instance_type',
            terraformGeneratorMetadata: {
                providerName: 'aws',
                providerVersion: '4.15.1',
                providerVersionConstraint: '~> 4.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._defaultCores = config.defaultCores;
        this._defaultThreadsPerCore = config.defaultThreadsPerCore;
        this._hypervisor = config.hypervisor;
        this._instanceType = config.instanceType;
        this._maximumIpv6AddressesPerInterface = config.maximumIpv6AddressesPerInterface;
        this._totalFpgaMemory = config.totalFpgaMemory;
        this._totalGpuMemory = config.totalGpuMemory;
        this._totalInstanceStorage = config.totalInstanceStorage;
        this._fpgas = config.fpgas;
        this._gpus = config.gpus;
        this._inferenceAccelerators = config.inferenceAccelerators;
        this._instanceDisks = config.instanceDisks;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // auto_recovery_supported - computed: true, optional: false, required: false
    get autoRecoverySupported() {
        return this.getBooleanAttribute('auto_recovery_supported');
    }
    // bare_metal - computed: true, optional: false, required: false
    get bareMetal() {
        return this.getBooleanAttribute('bare_metal');
    }
    // burstable_performance_supported - computed: true, optional: false, required: false
    get burstablePerformanceSupported() {
        return this.getBooleanAttribute('burstable_performance_supported');
    }
    // current_generation - computed: true, optional: false, required: false
    get currentGeneration() {
        return this.getBooleanAttribute('current_generation');
    }
    // dedicated_hosts_supported - computed: true, optional: false, required: false
    get dedicatedHostsSupported() {
        return this.getBooleanAttribute('dedicated_hosts_supported');
    }
    get defaultCores() {
        return this.getNumberAttribute('default_cores');
    }
    set defaultCores(value) {
        this._defaultCores = value;
    }
    resetDefaultCores() {
        this._defaultCores = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultCoresInput() {
        return this._defaultCores;
    }
    get defaultThreadsPerCore() {
        return this.getNumberAttribute('default_threads_per_core');
    }
    set defaultThreadsPerCore(value) {
        this._defaultThreadsPerCore = value;
    }
    resetDefaultThreadsPerCore() {
        this._defaultThreadsPerCore = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultThreadsPerCoreInput() {
        return this._defaultThreadsPerCore;
    }
    // default_vcpus - computed: true, optional: false, required: false
    get defaultVcpus() {
        return this.getNumberAttribute('default_vcpus');
    }
    // ebs_encryption_support - computed: true, optional: false, required: false
    get ebsEncryptionSupport() {
        return this.getStringAttribute('ebs_encryption_support');
    }
    // ebs_nvme_support - computed: true, optional: false, required: false
    get ebsNvmeSupport() {
        return this.getStringAttribute('ebs_nvme_support');
    }
    // ebs_optimized_support - computed: true, optional: false, required: false
    get ebsOptimizedSupport() {
        return this.getStringAttribute('ebs_optimized_support');
    }
    // ebs_performance_baseline_bandwidth - computed: true, optional: false, required: false
    get ebsPerformanceBaselineBandwidth() {
        return this.getNumberAttribute('ebs_performance_baseline_bandwidth');
    }
    // ebs_performance_baseline_iops - computed: true, optional: false, required: false
    get ebsPerformanceBaselineIops() {
        return this.getNumberAttribute('ebs_performance_baseline_iops');
    }
    // ebs_performance_baseline_throughput - computed: true, optional: false, required: false
    get ebsPerformanceBaselineThroughput() {
        return this.getNumberAttribute('ebs_performance_baseline_throughput');
    }
    // ebs_performance_maximum_bandwidth - computed: true, optional: false, required: false
    get ebsPerformanceMaximumBandwidth() {
        return this.getNumberAttribute('ebs_performance_maximum_bandwidth');
    }
    // ebs_performance_maximum_iops - computed: true, optional: false, required: false
    get ebsPerformanceMaximumIops() {
        return this.getNumberAttribute('ebs_performance_maximum_iops');
    }
    // ebs_performance_maximum_throughput - computed: true, optional: false, required: false
    get ebsPerformanceMaximumThroughput() {
        return this.getNumberAttribute('ebs_performance_maximum_throughput');
    }
    // efa_supported - computed: true, optional: false, required: false
    get efaSupported() {
        return this.getBooleanAttribute('efa_supported');
    }
    // ena_support - computed: true, optional: false, required: false
    get enaSupport() {
        return this.getStringAttribute('ena_support');
    }
    // encryption_in_transit_supported - computed: true, optional: false, required: false
    get encryptionInTransitSupported() {
        return this.getBooleanAttribute('encryption_in_transit_supported');
    }
    // free_tier_eligible - computed: true, optional: false, required: false
    get freeTierEligible() {
        return this.getBooleanAttribute('free_tier_eligible');
    }
    // hibernation_supported - computed: true, optional: false, required: false
    get hibernationSupported() {
        return this.getBooleanAttribute('hibernation_supported');
    }
    get hypervisor() {
        return this.getStringAttribute('hypervisor');
    }
    set hypervisor(value) {
        this._hypervisor = value;
    }
    resetHypervisor() {
        this._hypervisor = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hypervisorInput() {
        return this._hypervisor;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    // instance_storage_supported - computed: true, optional: false, required: false
    get instanceStorageSupported() {
        return this.getBooleanAttribute('instance_storage_supported');
    }
    get instanceType() {
        return this.getStringAttribute('instance_type');
    }
    set instanceType(value) {
        this._instanceType = value;
    }
    // Temporarily expose input value. Use with caution.
    get instanceTypeInput() {
        return this._instanceType;
    }
    // ipv6_supported - computed: true, optional: false, required: false
    get ipv6Supported() {
        return this.getBooleanAttribute('ipv6_supported');
    }
    // maximum_ipv4_addresses_per_interface - computed: true, optional: false, required: false
    get maximumIpv4AddressesPerInterface() {
        return this.getNumberAttribute('maximum_ipv4_addresses_per_interface');
    }
    get maximumIpv6AddressesPerInterface() {
        return this.getNumberAttribute('maximum_ipv6_addresses_per_interface');
    }
    set maximumIpv6AddressesPerInterface(value) {
        this._maximumIpv6AddressesPerInterface = value;
    }
    resetMaximumIpv6AddressesPerInterface() {
        this._maximumIpv6AddressesPerInterface = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maximumIpv6AddressesPerInterfaceInput() {
        return this._maximumIpv6AddressesPerInterface;
    }
    // maximum_network_interfaces - computed: true, optional: false, required: false
    get maximumNetworkInterfaces() {
        return this.getNumberAttribute('maximum_network_interfaces');
    }
    // memory_size - computed: true, optional: false, required: false
    get memorySize() {
        return this.getNumberAttribute('memory_size');
    }
    // network_performance - computed: true, optional: false, required: false
    get networkPerformance() {
        return this.getStringAttribute('network_performance');
    }
    // supported_architectures - computed: true, optional: false, required: false
    get supportedArchitectures() {
        return this.getListAttribute('supported_architectures');
    }
    // supported_placement_strategies - computed: true, optional: false, required: false
    get supportedPlacementStrategies() {
        return this.getListAttribute('supported_placement_strategies');
    }
    // supported_root_device_types - computed: true, optional: false, required: false
    get supportedRootDeviceTypes() {
        return this.getListAttribute('supported_root_device_types');
    }
    // supported_usages_classes - computed: true, optional: false, required: false
    get supportedUsagesClasses() {
        return this.getListAttribute('supported_usages_classes');
    }
    // supported_virtualization_types - computed: true, optional: false, required: false
    get supportedVirtualizationTypes() {
        return this.getListAttribute('supported_virtualization_types');
    }
    // sustained_clock_speed - computed: true, optional: false, required: false
    get sustainedClockSpeed() {
        return this.getNumberAttribute('sustained_clock_speed');
    }
    get totalFpgaMemory() {
        return this.getNumberAttribute('total_fpga_memory');
    }
    set totalFpgaMemory(value) {
        this._totalFpgaMemory = value;
    }
    resetTotalFpgaMemory() {
        this._totalFpgaMemory = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get totalFpgaMemoryInput() {
        return this._totalFpgaMemory;
    }
    get totalGpuMemory() {
        return this.getNumberAttribute('total_gpu_memory');
    }
    set totalGpuMemory(value) {
        this._totalGpuMemory = value;
    }
    resetTotalGpuMemory() {
        this._totalGpuMemory = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get totalGpuMemoryInput() {
        return this._totalGpuMemory;
    }
    get totalInstanceStorage() {
        return this.getNumberAttribute('total_instance_storage');
    }
    set totalInstanceStorage(value) {
        this._totalInstanceStorage = value;
    }
    resetTotalInstanceStorage() {
        this._totalInstanceStorage = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get totalInstanceStorageInput() {
        return this._totalInstanceStorage;
    }
    // valid_cores - computed: true, optional: false, required: false
    get validCores() {
        return this.getNumberListAttribute('valid_cores');
    }
    // valid_threads_per_core - computed: true, optional: false, required: false
    get validThreadsPerCore() {
        return this.getNumberListAttribute('valid_threads_per_core');
    }
    get fpgas() {
        // Getting the computed value is not yet implemented
        return cdktf.Token.asAny(cdktf.Fn.tolist(this.interpolationForAttribute('fpgas')));
    }
    set fpgas(value) {
        this._fpgas = value;
    }
    resetFpgas() {
        this._fpgas = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fpgasInput() {
        return this._fpgas;
    }
    get gpus() {
        // Getting the computed value is not yet implemented
        return cdktf.Token.asAny(cdktf.Fn.tolist(this.interpolationForAttribute('gpus')));
    }
    set gpus(value) {
        this._gpus = value;
    }
    resetGpus() {
        this._gpus = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get gpusInput() {
        return this._gpus;
    }
    get inferenceAccelerators() {
        // Getting the computed value is not yet implemented
        return cdktf.Token.asAny(cdktf.Fn.tolist(this.interpolationForAttribute('inference_accelerators')));
    }
    set inferenceAccelerators(value) {
        this._inferenceAccelerators = value;
    }
    resetInferenceAccelerators() {
        this._inferenceAccelerators = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get inferenceAcceleratorsInput() {
        return this._inferenceAccelerators;
    }
    get instanceDisks() {
        // Getting the computed value is not yet implemented
        return cdktf.Token.asAny(cdktf.Fn.tolist(this.interpolationForAttribute('instance_disks')));
    }
    set instanceDisks(value) {
        this._instanceDisks = value;
    }
    resetInstanceDisks() {
        this._instanceDisks = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get instanceDisksInput() {
        return this._instanceDisks;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            default_cores: cdktf.numberToTerraform(this._defaultCores),
            default_threads_per_core: cdktf.numberToTerraform(this._defaultThreadsPerCore),
            hypervisor: cdktf.stringToTerraform(this._hypervisor),
            instance_type: cdktf.stringToTerraform(this._instanceType),
            maximum_ipv6_addresses_per_interface: cdktf.numberToTerraform(this._maximumIpv6AddressesPerInterface),
            total_fpga_memory: cdktf.numberToTerraform(this._totalFpgaMemory),
            total_gpu_memory: cdktf.numberToTerraform(this._totalGpuMemory),
            total_instance_storage: cdktf.numberToTerraform(this._totalInstanceStorage),
            fpgas: cdktf.listMapper(dataAwsEc2InstanceTypeFpgasToTerraform)(this._fpgas),
            gpus: cdktf.listMapper(dataAwsEc2InstanceTypeGpusToTerraform)(this._gpus),
            inference_accelerators: cdktf.listMapper(dataAwsEc2InstanceTypeInferenceAcceleratorsToTerraform)(this._inferenceAccelerators),
            instance_disks: cdktf.listMapper(dataAwsEc2InstanceTypeInstanceDisksToTerraform)(this._instanceDisks),
        };
    }
}
exports.DataAwsEc2InstanceType = DataAwsEc2InstanceType;
_a = JSII_RTTI_SYMBOL_1;
DataAwsEc2InstanceType[_a] = { fqn: "@cdktf/provider-aws.ec2.DataAwsEc2InstanceType", version: "7.0.64" };
// =================
// STATIC PROPERTIES
// =================
DataAwsEc2InstanceType.tfResourceType = "aws_ec2_instance_type";
//# sourceMappingURL=data:application/json;base64,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