import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS EC2
*/
export interface DataAwsEc2InstanceTypesConfig extends cdktf.TerraformMetaArguments {
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ec2_instance_types#filter DataAwsEc2InstanceTypes#filter}
    */
    readonly filter?: DataAwsEc2InstanceTypesFilter[] | cdktf.IResolvable;
}
export interface DataAwsEc2InstanceTypesFilter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ec2_instance_types#name DataAwsEc2InstanceTypes#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ec2_instance_types#values DataAwsEc2InstanceTypes#values}
    */
    readonly values: string[];
}
export declare function dataAwsEc2InstanceTypesFilterToTerraform(struct?: DataAwsEc2InstanceTypesFilter | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/ec2_instance_types aws_ec2_instance_types}
*/
export declare class DataAwsEc2InstanceTypes extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_ec2_instance_types";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/ec2_instance_types aws_ec2_instance_types} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsEc2InstanceTypesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAwsEc2InstanceTypesConfig);
    get id(): string;
    get instanceTypes(): string[];
    private _filter?;
    get filter(): DataAwsEc2InstanceTypesFilter[] | cdktf.IResolvable;
    set filter(value: DataAwsEc2InstanceTypesFilter[] | cdktf.IResolvable);
    resetFilter(): void;
    get filterInput(): cdktf.IResolvable | DataAwsEc2InstanceTypesFilter[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-ec2-instance-types.d.ts.map