import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS EC2
*/
export interface DataAwsEc2SpotPriceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ec2_spot_price#availability_zone DataAwsEc2SpotPrice#availability_zone}
    */
    readonly availabilityZone?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ec2_spot_price#instance_type DataAwsEc2SpotPrice#instance_type}
    */
    readonly instanceType?: string;
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ec2_spot_price#filter DataAwsEc2SpotPrice#filter}
    */
    readonly filter?: DataAwsEc2SpotPriceFilter[] | cdktf.IResolvable;
}
export interface DataAwsEc2SpotPriceFilter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ec2_spot_price#name DataAwsEc2SpotPrice#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ec2_spot_price#values DataAwsEc2SpotPrice#values}
    */
    readonly values: string[];
}
export declare function dataAwsEc2SpotPriceFilterToTerraform(struct?: DataAwsEc2SpotPriceFilter | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/ec2_spot_price aws_ec2_spot_price}
*/
export declare class DataAwsEc2SpotPrice extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_ec2_spot_price";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/ec2_spot_price aws_ec2_spot_price} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsEc2SpotPriceConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAwsEc2SpotPriceConfig);
    private _availabilityZone?;
    get availabilityZone(): string;
    set availabilityZone(value: string);
    resetAvailabilityZone(): void;
    get availabilityZoneInput(): string | undefined;
    get id(): string;
    private _instanceType?;
    get instanceType(): string;
    set instanceType(value: string);
    resetInstanceType(): void;
    get instanceTypeInput(): string | undefined;
    get spotPrice(): string;
    get spotPriceTimestamp(): string;
    private _filter?;
    get filter(): DataAwsEc2SpotPriceFilter[] | cdktf.IResolvable;
    set filter(value: DataAwsEc2SpotPriceFilter[] | cdktf.IResolvable);
    resetFilter(): void;
    get filterInput(): cdktf.IResolvable | DataAwsEc2SpotPriceFilter[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-ec2-spot-price.d.ts.map