import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS EC2
*/
export interface DataAwsEc2TransitGatewayConnectPeerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ec2_transit_gateway_connect_peer#tags DataAwsEc2TransitGatewayConnectPeer#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ec2_transit_gateway_connect_peer#transit_gateway_connect_peer_id DataAwsEc2TransitGatewayConnectPeer#transit_gateway_connect_peer_id}
    */
    readonly transitGatewayConnectPeerId?: string;
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ec2_transit_gateway_connect_peer#filter DataAwsEc2TransitGatewayConnectPeer#filter}
    */
    readonly filter?: DataAwsEc2TransitGatewayConnectPeerFilter[] | cdktf.IResolvable;
}
export interface DataAwsEc2TransitGatewayConnectPeerFilter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ec2_transit_gateway_connect_peer#name DataAwsEc2TransitGatewayConnectPeer#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ec2_transit_gateway_connect_peer#values DataAwsEc2TransitGatewayConnectPeer#values}
    */
    readonly values: string[];
}
export declare function dataAwsEc2TransitGatewayConnectPeerFilterToTerraform(struct?: DataAwsEc2TransitGatewayConnectPeerFilter | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/ec2_transit_gateway_connect_peer aws_ec2_transit_gateway_connect_peer}
*/
export declare class DataAwsEc2TransitGatewayConnectPeer extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_ec2_transit_gateway_connect_peer";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/ec2_transit_gateway_connect_peer aws_ec2_transit_gateway_connect_peer} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsEc2TransitGatewayConnectPeerConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAwsEc2TransitGatewayConnectPeerConfig);
    get arn(): string;
    get bgpAsn(): string;
    get id(): string;
    get insideCidrBlocks(): string[];
    get peerAddress(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get transitGatewayAddress(): string;
    get transitGatewayAttachmentId(): string;
    private _transitGatewayConnectPeerId?;
    get transitGatewayConnectPeerId(): string;
    set transitGatewayConnectPeerId(value: string);
    resetTransitGatewayConnectPeerId(): void;
    get transitGatewayConnectPeerIdInput(): string | undefined;
    private _filter?;
    get filter(): DataAwsEc2TransitGatewayConnectPeerFilter[] | cdktf.IResolvable;
    set filter(value: DataAwsEc2TransitGatewayConnectPeerFilter[] | cdktf.IResolvable);
    resetFilter(): void;
    get filterInput(): cdktf.IResolvable | DataAwsEc2TransitGatewayConnectPeerFilter[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-ec2-transit-gateway-connect-peer.d.ts.map