import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS EC2
*/
export interface DataAwsEc2TransitGatewayConnectConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ec2_transit_gateway_connect#tags DataAwsEc2TransitGatewayConnect#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ec2_transit_gateway_connect#transit_gateway_connect_id DataAwsEc2TransitGatewayConnect#transit_gateway_connect_id}
    */
    readonly transitGatewayConnectId?: string;
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ec2_transit_gateway_connect#filter DataAwsEc2TransitGatewayConnect#filter}
    */
    readonly filter?: DataAwsEc2TransitGatewayConnectFilter[] | cdktf.IResolvable;
}
export interface DataAwsEc2TransitGatewayConnectFilter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ec2_transit_gateway_connect#name DataAwsEc2TransitGatewayConnect#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ec2_transit_gateway_connect#values DataAwsEc2TransitGatewayConnect#values}
    */
    readonly values: string[];
}
export declare function dataAwsEc2TransitGatewayConnectFilterToTerraform(struct?: DataAwsEc2TransitGatewayConnectFilter | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/ec2_transit_gateway_connect aws_ec2_transit_gateway_connect}
*/
export declare class DataAwsEc2TransitGatewayConnect extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_ec2_transit_gateway_connect";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/ec2_transit_gateway_connect aws_ec2_transit_gateway_connect} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsEc2TransitGatewayConnectConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAwsEc2TransitGatewayConnectConfig);
    get id(): string;
    get protocol(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _transitGatewayConnectId?;
    get transitGatewayConnectId(): string;
    set transitGatewayConnectId(value: string);
    resetTransitGatewayConnectId(): void;
    get transitGatewayConnectIdInput(): string | undefined;
    get transitGatewayId(): string;
    get transportAttachmentId(): string;
    private _filter?;
    get filter(): DataAwsEc2TransitGatewayConnectFilter[] | cdktf.IResolvable;
    set filter(value: DataAwsEc2TransitGatewayConnectFilter[] | cdktf.IResolvable);
    resetFilter(): void;
    get filterInput(): cdktf.IResolvable | DataAwsEc2TransitGatewayConnectFilter[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-ec2-transit-gateway-connect.d.ts.map