import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS EC2
*/
export interface DataAwsEc2TransitGatewayMulticastDomainConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ec2_transit_gateway_multicast_domain#tags DataAwsEc2TransitGatewayMulticastDomain#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ec2_transit_gateway_multicast_domain#transit_gateway_multicast_domain_id DataAwsEc2TransitGatewayMulticastDomain#transit_gateway_multicast_domain_id}
    */
    readonly transitGatewayMulticastDomainId?: string;
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ec2_transit_gateway_multicast_domain#filter DataAwsEc2TransitGatewayMulticastDomain#filter}
    */
    readonly filter?: DataAwsEc2TransitGatewayMulticastDomainFilter[] | cdktf.IResolvable;
}
export interface DataAwsEc2TransitGatewayMulticastDomainAssociations {
}
export declare function dataAwsEc2TransitGatewayMulticastDomainAssociationsToTerraform(struct?: DataAwsEc2TransitGatewayMulticastDomainAssociations): any;
export declare class DataAwsEc2TransitGatewayMulticastDomainAssociationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsEc2TransitGatewayMulticastDomainAssociations | undefined;
    set internalValue(value: DataAwsEc2TransitGatewayMulticastDomainAssociations | undefined);
    get subnetId(): string;
    get transitGatewayAttachmentId(): string;
}
export declare class DataAwsEc2TransitGatewayMulticastDomainAssociationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsEc2TransitGatewayMulticastDomainAssociationsOutputReference;
}
export interface DataAwsEc2TransitGatewayMulticastDomainMembers {
}
export declare function dataAwsEc2TransitGatewayMulticastDomainMembersToTerraform(struct?: DataAwsEc2TransitGatewayMulticastDomainMembers): any;
export declare class DataAwsEc2TransitGatewayMulticastDomainMembersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsEc2TransitGatewayMulticastDomainMembers | undefined;
    set internalValue(value: DataAwsEc2TransitGatewayMulticastDomainMembers | undefined);
    get groupIpAddress(): string;
    get networkInterfaceId(): string;
}
export declare class DataAwsEc2TransitGatewayMulticastDomainMembersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsEc2TransitGatewayMulticastDomainMembersOutputReference;
}
export interface DataAwsEc2TransitGatewayMulticastDomainSources {
}
export declare function dataAwsEc2TransitGatewayMulticastDomainSourcesToTerraform(struct?: DataAwsEc2TransitGatewayMulticastDomainSources): any;
export declare class DataAwsEc2TransitGatewayMulticastDomainSourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsEc2TransitGatewayMulticastDomainSources | undefined;
    set internalValue(value: DataAwsEc2TransitGatewayMulticastDomainSources | undefined);
    get groupIpAddress(): string;
    get networkInterfaceId(): string;
}
export declare class DataAwsEc2TransitGatewayMulticastDomainSourcesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsEc2TransitGatewayMulticastDomainSourcesOutputReference;
}
export interface DataAwsEc2TransitGatewayMulticastDomainFilter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ec2_transit_gateway_multicast_domain#name DataAwsEc2TransitGatewayMulticastDomain#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ec2_transit_gateway_multicast_domain#values DataAwsEc2TransitGatewayMulticastDomain#values}
    */
    readonly values: string[];
}
export declare function dataAwsEc2TransitGatewayMulticastDomainFilterToTerraform(struct?: DataAwsEc2TransitGatewayMulticastDomainFilter | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/ec2_transit_gateway_multicast_domain aws_ec2_transit_gateway_multicast_domain}
*/
export declare class DataAwsEc2TransitGatewayMulticastDomain extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_ec2_transit_gateway_multicast_domain";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/ec2_transit_gateway_multicast_domain aws_ec2_transit_gateway_multicast_domain} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsEc2TransitGatewayMulticastDomainConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAwsEc2TransitGatewayMulticastDomainConfig);
    get arn(): string;
    private _associations;
    get associations(): DataAwsEc2TransitGatewayMulticastDomainAssociationsList;
    get autoAcceptSharedAssociations(): string;
    get id(): string;
    get igmpv2Support(): string;
    private _members;
    get members(): DataAwsEc2TransitGatewayMulticastDomainMembersList;
    get ownerId(): string;
    private _sources;
    get sources(): DataAwsEc2TransitGatewayMulticastDomainSourcesList;
    get state(): string;
    get staticSourcesSupport(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get transitGatewayAttachmentId(): string;
    get transitGatewayId(): string;
    private _transitGatewayMulticastDomainId?;
    get transitGatewayMulticastDomainId(): string;
    set transitGatewayMulticastDomainId(value: string);
    resetTransitGatewayMulticastDomainId(): void;
    get transitGatewayMulticastDomainIdInput(): string | undefined;
    private _filter?;
    get filter(): DataAwsEc2TransitGatewayMulticastDomainFilter[] | cdktf.IResolvable;
    set filter(value: DataAwsEc2TransitGatewayMulticastDomainFilter[] | cdktf.IResolvable);
    resetFilter(): void;
    get filterInput(): cdktf.IResolvable | DataAwsEc2TransitGatewayMulticastDomainFilter[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-ec2-transit-gateway-multicast-domain.d.ts.map