import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS EC2
*/
export interface DataAwsEipsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/eips#tags DataAwsEips#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/eips#filter DataAwsEips#filter}
    */
    readonly filter?: DataAwsEipsFilter[] | cdktf.IResolvable;
}
export interface DataAwsEipsFilter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/eips#name DataAwsEips#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/eips#values DataAwsEips#values}
    */
    readonly values: string[];
}
export declare function dataAwsEipsFilterToTerraform(struct?: DataAwsEipsFilter | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/eips aws_eips}
*/
export declare class DataAwsEips extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_eips";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/eips aws_eips} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsEipsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAwsEipsConfig);
    get allocationIds(): string[];
    get id(): string;
    get publicIps(): string[];
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _filter?;
    get filter(): DataAwsEipsFilter[] | cdktf.IResolvable;
    set filter(value: DataAwsEipsFilter[] | cdktf.IResolvable);
    resetFilter(): void;
    get filterInput(): cdktf.IResolvable | DataAwsEipsFilter[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-eips.d.ts.map