import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS EC2
*/
export interface DataAwsInstancesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/instances#instance_state_names DataAwsInstances#instance_state_names}
    */
    readonly instanceStateNames?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/instances#instance_tags DataAwsInstances#instance_tags}
    */
    readonly instanceTags?: {
        [key: string]: string;
    };
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/instances#filter DataAwsInstances#filter}
    */
    readonly filter?: DataAwsInstancesFilter[] | cdktf.IResolvable;
}
export interface DataAwsInstancesFilter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/instances#name DataAwsInstances#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/instances#values DataAwsInstances#values}
    */
    readonly values: string[];
}
export declare function dataAwsInstancesFilterToTerraform(struct?: DataAwsInstancesFilter | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/instances aws_instances}
*/
export declare class DataAwsInstances extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_instances";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/instances aws_instances} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsInstancesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAwsInstancesConfig);
    get id(): string;
    get ids(): string[];
    private _instanceStateNames?;
    get instanceStateNames(): string[];
    set instanceStateNames(value: string[]);
    resetInstanceStateNames(): void;
    get instanceStateNamesInput(): string[] | undefined;
    private _instanceTags?;
    get instanceTags(): {
        [key: string]: string;
    };
    set instanceTags(value: {
        [key: string]: string;
    });
    resetInstanceTags(): void;
    get instanceTagsInput(): {
        [key: string]: string;
    } | undefined;
    get privateIps(): string[];
    get publicIps(): string[];
    private _filter?;
    get filter(): DataAwsInstancesFilter[] | cdktf.IResolvable;
    set filter(value: DataAwsInstancesFilter[] | cdktf.IResolvable);
    resetFilter(): void;
    get filterInput(): cdktf.IResolvable | DataAwsInstancesFilter[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-instances.d.ts.map