import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS EC2
*/
export interface Ec2ClientVpnAuthorizationRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ec2_client_vpn_authorization_rule#access_group_id Ec2ClientVpnAuthorizationRule#access_group_id}
    */
    readonly accessGroupId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ec2_client_vpn_authorization_rule#authorize_all_groups Ec2ClientVpnAuthorizationRule#authorize_all_groups}
    */
    readonly authorizeAllGroups?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ec2_client_vpn_authorization_rule#client_vpn_endpoint_id Ec2ClientVpnAuthorizationRule#client_vpn_endpoint_id}
    */
    readonly clientVpnEndpointId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ec2_client_vpn_authorization_rule#description Ec2ClientVpnAuthorizationRule#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ec2_client_vpn_authorization_rule#target_network_cidr Ec2ClientVpnAuthorizationRule#target_network_cidr}
    */
    readonly targetNetworkCidr: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ec2_client_vpn_authorization_rule#timeouts Ec2ClientVpnAuthorizationRule#timeouts}
    */
    readonly timeouts?: Ec2ClientVpnAuthorizationRuleTimeouts;
}
export interface Ec2ClientVpnAuthorizationRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ec2_client_vpn_authorization_rule#create Ec2ClientVpnAuthorizationRule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ec2_client_vpn_authorization_rule#delete Ec2ClientVpnAuthorizationRule#delete}
    */
    readonly delete?: string;
}
export declare function ec2ClientVpnAuthorizationRuleTimeoutsToTerraform(struct?: Ec2ClientVpnAuthorizationRuleTimeoutsOutputReference | Ec2ClientVpnAuthorizationRuleTimeouts | cdktf.IResolvable): any;
export declare class Ec2ClientVpnAuthorizationRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): Ec2ClientVpnAuthorizationRuleTimeouts | undefined;
    set internalValue(value: Ec2ClientVpnAuthorizationRuleTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/ec2_client_vpn_authorization_rule aws_ec2_client_vpn_authorization_rule}
*/
export declare class Ec2ClientVpnAuthorizationRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_ec2_client_vpn_authorization_rule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/ec2_client_vpn_authorization_rule aws_ec2_client_vpn_authorization_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options Ec2ClientVpnAuthorizationRuleConfig
    */
    constructor(scope: Construct, id: string, config: Ec2ClientVpnAuthorizationRuleConfig);
    private _accessGroupId?;
    get accessGroupId(): string;
    set accessGroupId(value: string);
    resetAccessGroupId(): void;
    get accessGroupIdInput(): string | undefined;
    private _authorizeAllGroups?;
    get authorizeAllGroups(): boolean | cdktf.IResolvable;
    set authorizeAllGroups(value: boolean | cdktf.IResolvable);
    resetAuthorizeAllGroups(): void;
    get authorizeAllGroupsInput(): boolean | cdktf.IResolvable | undefined;
    private _clientVpnEndpointId?;
    get clientVpnEndpointId(): string;
    set clientVpnEndpointId(value: string);
    get clientVpnEndpointIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _targetNetworkCidr?;
    get targetNetworkCidr(): string;
    set targetNetworkCidr(value: string);
    get targetNetworkCidrInput(): string | undefined;
    private _timeouts;
    get timeouts(): Ec2ClientVpnAuthorizationRuleTimeoutsOutputReference;
    putTimeouts(value: Ec2ClientVpnAuthorizationRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): Ec2ClientVpnAuthorizationRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=ec2-client-vpn-authorization-rule.d.ts.map