"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ec2TransitGatewayPrefixListReference = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/ec2_transit_gateway_prefix_list_reference aws_ec2_transit_gateway_prefix_list_reference}
*/
class Ec2TransitGatewayPrefixListReference extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/ec2_transit_gateway_prefix_list_reference aws_ec2_transit_gateway_prefix_list_reference} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options Ec2TransitGatewayPrefixListReferenceConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_ec2_transit_gateway_prefix_list_reference',
            terraformGeneratorMetadata: {
                providerName: 'aws',
                providerVersion: '4.15.1',
                providerVersionConstraint: '~> 4.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._blackhole = config.blackhole;
        this._prefixListId = config.prefixListId;
        this._transitGatewayAttachmentId = config.transitGatewayAttachmentId;
        this._transitGatewayRouteTableId = config.transitGatewayRouteTableId;
    }
    get blackhole() {
        return this.getBooleanAttribute('blackhole');
    }
    set blackhole(value) {
        this._blackhole = value;
    }
    resetBlackhole() {
        this._blackhole = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get blackholeInput() {
        return this._blackhole;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get prefixListId() {
        return this.getStringAttribute('prefix_list_id');
    }
    set prefixListId(value) {
        this._prefixListId = value;
    }
    // Temporarily expose input value. Use with caution.
    get prefixListIdInput() {
        return this._prefixListId;
    }
    // prefix_list_owner_id - computed: true, optional: false, required: false
    get prefixListOwnerId() {
        return this.getStringAttribute('prefix_list_owner_id');
    }
    get transitGatewayAttachmentId() {
        return this.getStringAttribute('transit_gateway_attachment_id');
    }
    set transitGatewayAttachmentId(value) {
        this._transitGatewayAttachmentId = value;
    }
    resetTransitGatewayAttachmentId() {
        this._transitGatewayAttachmentId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get transitGatewayAttachmentIdInput() {
        return this._transitGatewayAttachmentId;
    }
    get transitGatewayRouteTableId() {
        return this.getStringAttribute('transit_gateway_route_table_id');
    }
    set transitGatewayRouteTableId(value) {
        this._transitGatewayRouteTableId = value;
    }
    // Temporarily expose input value. Use with caution.
    get transitGatewayRouteTableIdInput() {
        return this._transitGatewayRouteTableId;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            blackhole: cdktf.booleanToTerraform(this._blackhole),
            prefix_list_id: cdktf.stringToTerraform(this._prefixListId),
            transit_gateway_attachment_id: cdktf.stringToTerraform(this._transitGatewayAttachmentId),
            transit_gateway_route_table_id: cdktf.stringToTerraform(this._transitGatewayRouteTableId),
        };
    }
}
exports.Ec2TransitGatewayPrefixListReference = Ec2TransitGatewayPrefixListReference;
_a = JSII_RTTI_SYMBOL_1;
Ec2TransitGatewayPrefixListReference[_a] = { fqn: "@cdktf/provider-aws.ec2.Ec2TransitGatewayPrefixListReference", version: "7.0.64" };
// =================
// STATIC PROPERTIES
// =================
Ec2TransitGatewayPrefixListReference.tfResourceType = "aws_ec2_transit_gateway_prefix_list_reference";
//# sourceMappingURL=data:application/json;base64,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