import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS EC2
*/
export interface VolumeAttachmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/volume_attachment#device_name VolumeAttachment#device_name}
    */
    readonly deviceName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/volume_attachment#force_detach VolumeAttachment#force_detach}
    */
    readonly forceDetach?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/volume_attachment#instance_id VolumeAttachment#instance_id}
    */
    readonly instanceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/volume_attachment#skip_destroy VolumeAttachment#skip_destroy}
    */
    readonly skipDestroy?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/volume_attachment#stop_instance_before_detaching VolumeAttachment#stop_instance_before_detaching}
    */
    readonly stopInstanceBeforeDetaching?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/volume_attachment#volume_id VolumeAttachment#volume_id}
    */
    readonly volumeId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/volume_attachment#timeouts VolumeAttachment#timeouts}
    */
    readonly timeouts?: VolumeAttachmentTimeouts;
}
export interface VolumeAttachmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/volume_attachment#create VolumeAttachment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/volume_attachment#delete VolumeAttachment#delete}
    */
    readonly delete?: string;
}
export declare function volumeAttachmentTimeoutsToTerraform(struct?: VolumeAttachmentTimeoutsOutputReference | VolumeAttachmentTimeouts | cdktf.IResolvable): any;
export declare class VolumeAttachmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VolumeAttachmentTimeouts | undefined;
    set internalValue(value: VolumeAttachmentTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/volume_attachment aws_volume_attachment}
*/
export declare class VolumeAttachment extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_volume_attachment";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/volume_attachment aws_volume_attachment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VolumeAttachmentConfig
    */
    constructor(scope: Construct, id: string, config: VolumeAttachmentConfig);
    private _deviceName?;
    get deviceName(): string;
    set deviceName(value: string);
    get deviceNameInput(): string | undefined;
    private _forceDetach?;
    get forceDetach(): boolean | cdktf.IResolvable;
    set forceDetach(value: boolean | cdktf.IResolvable);
    resetForceDetach(): void;
    get forceDetachInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _instanceId?;
    get instanceId(): string;
    set instanceId(value: string);
    get instanceIdInput(): string | undefined;
    private _skipDestroy?;
    get skipDestroy(): boolean | cdktf.IResolvable;
    set skipDestroy(value: boolean | cdktf.IResolvable);
    resetSkipDestroy(): void;
    get skipDestroyInput(): boolean | cdktf.IResolvable | undefined;
    private _stopInstanceBeforeDetaching?;
    get stopInstanceBeforeDetaching(): boolean | cdktf.IResolvable;
    set stopInstanceBeforeDetaching(value: boolean | cdktf.IResolvable);
    resetStopInstanceBeforeDetaching(): void;
    get stopInstanceBeforeDetachingInput(): boolean | cdktf.IResolvable | undefined;
    private _volumeId?;
    get volumeId(): string;
    set volumeId(value: string);
    get volumeIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): VolumeAttachmentTimeoutsOutputReference;
    putTimeouts(value: VolumeAttachmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): VolumeAttachmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=volume-attachment.d.ts.map