import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS EC2 Container Registry
*/
export interface EcrPullThroughCacheRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ecr_pull_through_cache_rule#ecr_repository_prefix EcrPullThroughCacheRule#ecr_repository_prefix}
    */
    readonly ecrRepositoryPrefix: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ecr_pull_through_cache_rule#upstream_registry_url EcrPullThroughCacheRule#upstream_registry_url}
    */
    readonly upstreamRegistryUrl: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/ecr_pull_through_cache_rule aws_ecr_pull_through_cache_rule}
*/
export declare class EcrPullThroughCacheRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_ecr_pull_through_cache_rule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/ecr_pull_through_cache_rule aws_ecr_pull_through_cache_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options EcrPullThroughCacheRuleConfig
    */
    constructor(scope: Construct, id: string, config: EcrPullThroughCacheRuleConfig);
    private _ecrRepositoryPrefix?;
    get ecrRepositoryPrefix(): string;
    set ecrRepositoryPrefix(value: string);
    get ecrRepositoryPrefixInput(): string | undefined;
    get id(): string;
    get registryId(): string;
    private _upstreamRegistryUrl?;
    get upstreamRegistryUrl(): string;
    set upstreamRegistryUrl(value: string);
    get upstreamRegistryUrlInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=ecr-pull-through-cache-rule.d.ts.map