import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS EC2 Container Registry
*/
export interface EcrReplicationConfigurationConfig extends cdktf.TerraformMetaArguments {
    /**
    * replication_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ecr_replication_configuration#replication_configuration EcrReplicationConfiguration#replication_configuration}
    */
    readonly replicationConfiguration?: EcrReplicationConfigurationReplicationConfiguration;
}
export interface EcrReplicationConfigurationReplicationConfigurationRuleDestination {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ecr_replication_configuration#region EcrReplicationConfiguration#region}
    */
    readonly region: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ecr_replication_configuration#registry_id EcrReplicationConfiguration#registry_id}
    */
    readonly registryId: string;
}
export declare function ecrReplicationConfigurationReplicationConfigurationRuleDestinationToTerraform(struct?: EcrReplicationConfigurationReplicationConfigurationRuleDestination | cdktf.IResolvable): any;
export interface EcrReplicationConfigurationReplicationConfigurationRuleRepositoryFilter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ecr_replication_configuration#filter EcrReplicationConfiguration#filter}
    */
    readonly filter: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ecr_replication_configuration#filter_type EcrReplicationConfiguration#filter_type}
    */
    readonly filterType: string;
}
export declare function ecrReplicationConfigurationReplicationConfigurationRuleRepositoryFilterToTerraform(struct?: EcrReplicationConfigurationReplicationConfigurationRuleRepositoryFilter | cdktf.IResolvable): any;
export interface EcrReplicationConfigurationReplicationConfigurationRule {
    /**
    * destination block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ecr_replication_configuration#destination EcrReplicationConfiguration#destination}
    */
    readonly destination: EcrReplicationConfigurationReplicationConfigurationRuleDestination[] | cdktf.IResolvable;
    /**
    * repository_filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ecr_replication_configuration#repository_filter EcrReplicationConfiguration#repository_filter}
    */
    readonly repositoryFilter?: EcrReplicationConfigurationReplicationConfigurationRuleRepositoryFilter[] | cdktf.IResolvable;
}
export declare function ecrReplicationConfigurationReplicationConfigurationRuleToTerraform(struct?: EcrReplicationConfigurationReplicationConfigurationRule | cdktf.IResolvable): any;
export interface EcrReplicationConfigurationReplicationConfiguration {
    /**
    * rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ecr_replication_configuration#rule EcrReplicationConfiguration#rule}
    */
    readonly rule: EcrReplicationConfigurationReplicationConfigurationRule[] | cdktf.IResolvable;
}
export declare function ecrReplicationConfigurationReplicationConfigurationToTerraform(struct?: EcrReplicationConfigurationReplicationConfigurationOutputReference | EcrReplicationConfigurationReplicationConfiguration): any;
export declare class EcrReplicationConfigurationReplicationConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EcrReplicationConfigurationReplicationConfiguration | undefined;
    set internalValue(value: EcrReplicationConfigurationReplicationConfiguration | undefined);
    private _rule?;
    get rule(): EcrReplicationConfigurationReplicationConfigurationRule[] | cdktf.IResolvable;
    set rule(value: EcrReplicationConfigurationReplicationConfigurationRule[] | cdktf.IResolvable);
    get ruleInput(): cdktf.IResolvable | EcrReplicationConfigurationReplicationConfigurationRule[] | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/ecr_replication_configuration aws_ecr_replication_configuration}
*/
export declare class EcrReplicationConfiguration extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_ecr_replication_configuration";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/ecr_replication_configuration aws_ecr_replication_configuration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options EcrReplicationConfigurationConfig = {}
    */
    constructor(scope: Construct, id: string, config?: EcrReplicationConfigurationConfig);
    get id(): string;
    get registryId(): string;
    private _replicationConfiguration;
    get replicationConfiguration(): EcrReplicationConfigurationReplicationConfigurationOutputReference;
    putReplicationConfiguration(value: EcrReplicationConfigurationReplicationConfiguration): void;
    resetReplicationConfiguration(): void;
    get replicationConfigurationInput(): EcrReplicationConfigurationReplicationConfiguration | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=ecr-replication-configuration.d.ts.map