import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS EC2 Container Service
*/
export interface DataAwsEcsContainerDefinitionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ecs_container_definition#container_name DataAwsEcsContainerDefinition#container_name}
    */
    readonly containerName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ecs_container_definition#task_definition DataAwsEcsContainerDefinition#task_definition}
    */
    readonly taskDefinition: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/ecs_container_definition aws_ecs_container_definition}
*/
export declare class DataAwsEcsContainerDefinition extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_ecs_container_definition";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/ecs_container_definition aws_ecs_container_definition} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsEcsContainerDefinitionConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsEcsContainerDefinitionConfig);
    private _containerName?;
    get containerName(): string;
    set containerName(value: string);
    get containerNameInput(): string | undefined;
    get cpu(): number;
    get disableNetworking(): cdktf.IResolvable;
    dockerLabels(key: string): string | cdktf.IResolvable;
    environment(key: string): string | cdktf.IResolvable;
    get id(): string;
    get image(): string;
    get imageDigest(): string;
    get memory(): number;
    get memoryReservation(): number;
    private _taskDefinition?;
    get taskDefinition(): string;
    set taskDefinition(value: string);
    get taskDefinitionInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-ecs-container-definition.d.ts.map