import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS EC2 Container Service
*/
export interface EcsClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ecs_cluster#capacity_providers EcsCluster#capacity_providers}
    */
    readonly capacityProviders?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ecs_cluster#name EcsCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ecs_cluster#tags EcsCluster#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ecs_cluster#tags_all EcsCluster#tags_all}
    */
    readonly tagsAll?: {
        [key: string]: string;
    };
    /**
    * configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ecs_cluster#configuration EcsCluster#configuration}
    */
    readonly configuration?: EcsClusterConfiguration;
    /**
    * default_capacity_provider_strategy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ecs_cluster#default_capacity_provider_strategy EcsCluster#default_capacity_provider_strategy}
    */
    readonly defaultCapacityProviderStrategy?: EcsClusterDefaultCapacityProviderStrategy[] | cdktf.IResolvable;
    /**
    * setting block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ecs_cluster#setting EcsCluster#setting}
    */
    readonly setting?: EcsClusterSetting[] | cdktf.IResolvable;
}
export interface EcsClusterConfigurationExecuteCommandConfigurationLogConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ecs_cluster#cloud_watch_encryption_enabled EcsCluster#cloud_watch_encryption_enabled}
    */
    readonly cloudWatchEncryptionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ecs_cluster#cloud_watch_log_group_name EcsCluster#cloud_watch_log_group_name}
    */
    readonly cloudWatchLogGroupName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ecs_cluster#s3_bucket_encryption_enabled EcsCluster#s3_bucket_encryption_enabled}
    */
    readonly s3BucketEncryptionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ecs_cluster#s3_bucket_name EcsCluster#s3_bucket_name}
    */
    readonly s3BucketName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ecs_cluster#s3_key_prefix EcsCluster#s3_key_prefix}
    */
    readonly s3KeyPrefix?: string;
}
export declare function ecsClusterConfigurationExecuteCommandConfigurationLogConfigurationToTerraform(struct?: EcsClusterConfigurationExecuteCommandConfigurationLogConfigurationOutputReference | EcsClusterConfigurationExecuteCommandConfigurationLogConfiguration): any;
export declare class EcsClusterConfigurationExecuteCommandConfigurationLogConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EcsClusterConfigurationExecuteCommandConfigurationLogConfiguration | undefined;
    set internalValue(value: EcsClusterConfigurationExecuteCommandConfigurationLogConfiguration | undefined);
    private _cloudWatchEncryptionEnabled?;
    get cloudWatchEncryptionEnabled(): boolean | cdktf.IResolvable;
    set cloudWatchEncryptionEnabled(value: boolean | cdktf.IResolvable);
    resetCloudWatchEncryptionEnabled(): void;
    get cloudWatchEncryptionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _cloudWatchLogGroupName?;
    get cloudWatchLogGroupName(): string;
    set cloudWatchLogGroupName(value: string);
    resetCloudWatchLogGroupName(): void;
    get cloudWatchLogGroupNameInput(): string | undefined;
    private _s3BucketEncryptionEnabled?;
    get s3BucketEncryptionEnabled(): boolean | cdktf.IResolvable;
    set s3BucketEncryptionEnabled(value: boolean | cdktf.IResolvable);
    resetS3BucketEncryptionEnabled(): void;
    get s3BucketEncryptionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _s3BucketName?;
    get s3BucketName(): string;
    set s3BucketName(value: string);
    resetS3BucketName(): void;
    get s3BucketNameInput(): string | undefined;
    private _s3KeyPrefix?;
    get s3KeyPrefix(): string;
    set s3KeyPrefix(value: string);
    resetS3KeyPrefix(): void;
    get s3KeyPrefixInput(): string | undefined;
}
export interface EcsClusterConfigurationExecuteCommandConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ecs_cluster#kms_key_id EcsCluster#kms_key_id}
    */
    readonly kmsKeyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ecs_cluster#logging EcsCluster#logging}
    */
    readonly logging?: string;
    /**
    * log_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ecs_cluster#log_configuration EcsCluster#log_configuration}
    */
    readonly logConfiguration?: EcsClusterConfigurationExecuteCommandConfigurationLogConfiguration;
}
export declare function ecsClusterConfigurationExecuteCommandConfigurationToTerraform(struct?: EcsClusterConfigurationExecuteCommandConfigurationOutputReference | EcsClusterConfigurationExecuteCommandConfiguration): any;
export declare class EcsClusterConfigurationExecuteCommandConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EcsClusterConfigurationExecuteCommandConfiguration | undefined;
    set internalValue(value: EcsClusterConfigurationExecuteCommandConfiguration | undefined);
    private _kmsKeyId?;
    get kmsKeyId(): string;
    set kmsKeyId(value: string);
    resetKmsKeyId(): void;
    get kmsKeyIdInput(): string | undefined;
    private _logging?;
    get logging(): string;
    set logging(value: string);
    resetLogging(): void;
    get loggingInput(): string | undefined;
    private _logConfiguration;
    get logConfiguration(): EcsClusterConfigurationExecuteCommandConfigurationLogConfigurationOutputReference;
    putLogConfiguration(value: EcsClusterConfigurationExecuteCommandConfigurationLogConfiguration): void;
    resetLogConfiguration(): void;
    get logConfigurationInput(): EcsClusterConfigurationExecuteCommandConfigurationLogConfiguration | undefined;
}
export interface EcsClusterConfiguration {
    /**
    * execute_command_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ecs_cluster#execute_command_configuration EcsCluster#execute_command_configuration}
    */
    readonly executeCommandConfiguration?: EcsClusterConfigurationExecuteCommandConfiguration;
}
export declare function ecsClusterConfigurationToTerraform(struct?: EcsClusterConfigurationOutputReference | EcsClusterConfiguration): any;
export declare class EcsClusterConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EcsClusterConfiguration | undefined;
    set internalValue(value: EcsClusterConfiguration | undefined);
    private _executeCommandConfiguration;
    get executeCommandConfiguration(): EcsClusterConfigurationExecuteCommandConfigurationOutputReference;
    putExecuteCommandConfiguration(value: EcsClusterConfigurationExecuteCommandConfiguration): void;
    resetExecuteCommandConfiguration(): void;
    get executeCommandConfigurationInput(): EcsClusterConfigurationExecuteCommandConfiguration | undefined;
}
export interface EcsClusterDefaultCapacityProviderStrategy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ecs_cluster#base EcsCluster#base}
    */
    readonly base?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ecs_cluster#capacity_provider EcsCluster#capacity_provider}
    */
    readonly capacityProvider: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ecs_cluster#weight EcsCluster#weight}
    */
    readonly weight?: number;
}
export declare function ecsClusterDefaultCapacityProviderStrategyToTerraform(struct?: EcsClusterDefaultCapacityProviderStrategy | cdktf.IResolvable): any;
export interface EcsClusterSetting {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ecs_cluster#name EcsCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ecs_cluster#value EcsCluster#value}
    */
    readonly value: string;
}
export declare function ecsClusterSettingToTerraform(struct?: EcsClusterSetting | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/ecs_cluster aws_ecs_cluster}
*/
export declare class EcsCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_ecs_cluster";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/ecs_cluster aws_ecs_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options EcsClusterConfig
    */
    constructor(scope: Construct, id: string, config: EcsClusterConfig);
    get arn(): string;
    private _capacityProviders?;
    get capacityProviders(): string[];
    set capacityProviders(value: string[]);
    resetCapacityProviders(): void;
    get capacityProvidersInput(): string[] | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tagsAll?;
    get tagsAll(): {
        [key: string]: string;
    };
    set tagsAll(value: {
        [key: string]: string;
    });
    resetTagsAll(): void;
    get tagsAllInput(): {
        [key: string]: string;
    } | undefined;
    private _configuration;
    get configuration(): EcsClusterConfigurationOutputReference;
    putConfiguration(value: EcsClusterConfiguration): void;
    resetConfiguration(): void;
    get configurationInput(): EcsClusterConfiguration | undefined;
    private _defaultCapacityProviderStrategy?;
    get defaultCapacityProviderStrategy(): EcsClusterDefaultCapacityProviderStrategy[] | cdktf.IResolvable;
    set defaultCapacityProviderStrategy(value: EcsClusterDefaultCapacityProviderStrategy[] | cdktf.IResolvable);
    resetDefaultCapacityProviderStrategy(): void;
    get defaultCapacityProviderStrategyInput(): cdktf.IResolvable | EcsClusterDefaultCapacityProviderStrategy[] | undefined;
    private _setting?;
    get setting(): EcsClusterSetting[] | cdktf.IResolvable;
    set setting(value: EcsClusterSetting[] | cdktf.IResolvable);
    resetSetting(): void;
    get settingInput(): cdktf.IResolvable | EcsClusterSetting[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=ecs-cluster.d.ts.map