import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS EFS
*/
export interface DataAwsEfsAccessPointConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/efs_access_point#access_point_id DataAwsEfsAccessPoint#access_point_id}
    */
    readonly accessPointId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/efs_access_point#tags DataAwsEfsAccessPoint#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
}
export interface DataAwsEfsAccessPointPosixUser {
}
export declare function dataAwsEfsAccessPointPosixUserToTerraform(struct?: DataAwsEfsAccessPointPosixUser): any;
export declare class DataAwsEfsAccessPointPosixUserOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsEfsAccessPointPosixUser | undefined;
    set internalValue(value: DataAwsEfsAccessPointPosixUser | undefined);
    get gid(): number;
    get secondaryGids(): number[];
    get uid(): number;
}
export declare class DataAwsEfsAccessPointPosixUserList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsEfsAccessPointPosixUserOutputReference;
}
export interface DataAwsEfsAccessPointRootDirectoryCreationInfo {
}
export declare function dataAwsEfsAccessPointRootDirectoryCreationInfoToTerraform(struct?: DataAwsEfsAccessPointRootDirectoryCreationInfo): any;
export declare class DataAwsEfsAccessPointRootDirectoryCreationInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsEfsAccessPointRootDirectoryCreationInfo | undefined;
    set internalValue(value: DataAwsEfsAccessPointRootDirectoryCreationInfo | undefined);
    get ownerGid(): number;
    get ownerUid(): number;
    get permissions(): string;
}
export declare class DataAwsEfsAccessPointRootDirectoryCreationInfoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsEfsAccessPointRootDirectoryCreationInfoOutputReference;
}
export interface DataAwsEfsAccessPointRootDirectory {
}
export declare function dataAwsEfsAccessPointRootDirectoryToTerraform(struct?: DataAwsEfsAccessPointRootDirectory): any;
export declare class DataAwsEfsAccessPointRootDirectoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsEfsAccessPointRootDirectory | undefined;
    set internalValue(value: DataAwsEfsAccessPointRootDirectory | undefined);
    private _creationInfo;
    get creationInfo(): DataAwsEfsAccessPointRootDirectoryCreationInfoList;
    get path(): string;
}
export declare class DataAwsEfsAccessPointRootDirectoryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsEfsAccessPointRootDirectoryOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/efs_access_point aws_efs_access_point}
*/
export declare class DataAwsEfsAccessPoint extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_efs_access_point";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/efs_access_point aws_efs_access_point} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsEfsAccessPointConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsEfsAccessPointConfig);
    private _accessPointId?;
    get accessPointId(): string;
    set accessPointId(value: string);
    get accessPointIdInput(): string | undefined;
    get arn(): string;
    get fileSystemArn(): string;
    get fileSystemId(): string;
    get id(): string;
    get ownerId(): string;
    private _posixUser;
    get posixUser(): DataAwsEfsAccessPointPosixUserList;
    private _rootDirectory;
    get rootDirectory(): DataAwsEfsAccessPointRootDirectoryList;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-efs-access-point.d.ts.map