import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS EFS
*/
export interface DataAwsEfsFileSystemConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/efs_file_system#creation_token DataAwsEfsFileSystem#creation_token}
    */
    readonly creationToken?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/efs_file_system#file_system_id DataAwsEfsFileSystem#file_system_id}
    */
    readonly fileSystemId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/efs_file_system#tags DataAwsEfsFileSystem#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
}
export interface DataAwsEfsFileSystemLifecyclePolicy {
}
export declare function dataAwsEfsFileSystemLifecyclePolicyToTerraform(struct?: DataAwsEfsFileSystemLifecyclePolicy): any;
export declare class DataAwsEfsFileSystemLifecyclePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsEfsFileSystemLifecyclePolicy | undefined;
    set internalValue(value: DataAwsEfsFileSystemLifecyclePolicy | undefined);
    get transitionToIa(): string;
    get transitionToPrimaryStorageClass(): string;
}
export declare class DataAwsEfsFileSystemLifecyclePolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsEfsFileSystemLifecyclePolicyOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/efs_file_system aws_efs_file_system}
*/
export declare class DataAwsEfsFileSystem extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_efs_file_system";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/efs_file_system aws_efs_file_system} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsEfsFileSystemConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAwsEfsFileSystemConfig);
    get arn(): string;
    get availabilityZoneId(): string;
    get availabilityZoneName(): string;
    private _creationToken?;
    get creationToken(): string;
    set creationToken(value: string);
    resetCreationToken(): void;
    get creationTokenInput(): string | undefined;
    get dnsName(): string;
    get encrypted(): cdktf.IResolvable;
    private _fileSystemId?;
    get fileSystemId(): string;
    set fileSystemId(value: string);
    resetFileSystemId(): void;
    get fileSystemIdInput(): string | undefined;
    get id(): string;
    get kmsKeyId(): string;
    private _lifecyclePolicy;
    get lifecyclePolicy(): DataAwsEfsFileSystemLifecyclePolicyList;
    get performanceMode(): string;
    get provisionedThroughputInMibps(): number;
    get sizeInBytes(): number;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get throughputMode(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-efs-file-system.d.ts.map