import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Elastic Kubernetes Service
*/
export interface EksClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/eks_cluster#enabled_cluster_log_types EksCluster#enabled_cluster_log_types}
    */
    readonly enabledClusterLogTypes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/eks_cluster#name EksCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/eks_cluster#role_arn EksCluster#role_arn}
    */
    readonly roleArn: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/eks_cluster#tags EksCluster#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/eks_cluster#tags_all EksCluster#tags_all}
    */
    readonly tagsAll?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/eks_cluster#version EksCluster#version}
    */
    readonly version?: string;
    /**
    * encryption_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/eks_cluster#encryption_config EksCluster#encryption_config}
    */
    readonly encryptionConfig?: EksClusterEncryptionConfig;
    /**
    * kubernetes_network_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/eks_cluster#kubernetes_network_config EksCluster#kubernetes_network_config}
    */
    readonly kubernetesNetworkConfig?: EksClusterKubernetesNetworkConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/eks_cluster#timeouts EksCluster#timeouts}
    */
    readonly timeouts?: EksClusterTimeouts;
    /**
    * vpc_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/eks_cluster#vpc_config EksCluster#vpc_config}
    */
    readonly vpcConfig: EksClusterVpcConfig;
}
export interface EksClusterCertificateAuthority {
}
export declare function eksClusterCertificateAuthorityToTerraform(struct?: EksClusterCertificateAuthority): any;
export declare class EksClusterCertificateAuthorityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): EksClusterCertificateAuthority | undefined;
    set internalValue(value: EksClusterCertificateAuthority | undefined);
    get data(): string;
}
export declare class EksClusterCertificateAuthorityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): EksClusterCertificateAuthorityOutputReference;
}
export interface EksClusterIdentityOidc {
}
export declare function eksClusterIdentityOidcToTerraform(struct?: EksClusterIdentityOidc): any;
export declare class EksClusterIdentityOidcOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): EksClusterIdentityOidc | undefined;
    set internalValue(value: EksClusterIdentityOidc | undefined);
    get issuer(): string;
}
export declare class EksClusterIdentityOidcList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): EksClusterIdentityOidcOutputReference;
}
export interface EksClusterIdentity {
}
export declare function eksClusterIdentityToTerraform(struct?: EksClusterIdentity): any;
export declare class EksClusterIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): EksClusterIdentity | undefined;
    set internalValue(value: EksClusterIdentity | undefined);
    private _oidc;
    get oidc(): EksClusterIdentityOidcList;
}
export declare class EksClusterIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): EksClusterIdentityOutputReference;
}
export interface EksClusterEncryptionConfigProvider {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/eks_cluster#key_arn EksCluster#key_arn}
    */
    readonly keyArn: string;
}
export declare function eksClusterEncryptionConfigProviderToTerraform(struct?: EksClusterEncryptionConfigProviderOutputReference | EksClusterEncryptionConfigProvider): any;
export declare class EksClusterEncryptionConfigProviderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EksClusterEncryptionConfigProvider | undefined;
    set internalValue(value: EksClusterEncryptionConfigProvider | undefined);
    private _keyArn?;
    get keyArn(): string;
    set keyArn(value: string);
    get keyArnInput(): string | undefined;
}
export interface EksClusterEncryptionConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/eks_cluster#resources EksCluster#resources}
    */
    readonly resources: string[];
    /**
    * provider block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/eks_cluster#provider EksCluster#provider}
    */
    readonly provider: EksClusterEncryptionConfigProvider;
}
export declare function eksClusterEncryptionConfigToTerraform(struct?: EksClusterEncryptionConfigOutputReference | EksClusterEncryptionConfig): any;
export declare class EksClusterEncryptionConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EksClusterEncryptionConfig | undefined;
    set internalValue(value: EksClusterEncryptionConfig | undefined);
    private _resources?;
    get resources(): string[];
    set resources(value: string[]);
    get resourcesInput(): string[] | undefined;
    private _provider;
    get provider(): EksClusterEncryptionConfigProviderOutputReference;
    putProvider(value: EksClusterEncryptionConfigProvider): void;
    get providerInput(): EksClusterEncryptionConfigProvider | undefined;
}
export interface EksClusterKubernetesNetworkConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/eks_cluster#ip_family EksCluster#ip_family}
    */
    readonly ipFamily?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/eks_cluster#service_ipv4_cidr EksCluster#service_ipv4_cidr}
    */
    readonly serviceIpv4Cidr?: string;
}
export declare function eksClusterKubernetesNetworkConfigToTerraform(struct?: EksClusterKubernetesNetworkConfigOutputReference | EksClusterKubernetesNetworkConfig): any;
export declare class EksClusterKubernetesNetworkConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EksClusterKubernetesNetworkConfig | undefined;
    set internalValue(value: EksClusterKubernetesNetworkConfig | undefined);
    private _ipFamily?;
    get ipFamily(): string;
    set ipFamily(value: string);
    resetIpFamily(): void;
    get ipFamilyInput(): string | undefined;
    private _serviceIpv4Cidr?;
    get serviceIpv4Cidr(): string;
    set serviceIpv4Cidr(value: string);
    resetServiceIpv4Cidr(): void;
    get serviceIpv4CidrInput(): string | undefined;
}
export interface EksClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/eks_cluster#create EksCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/eks_cluster#delete EksCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/eks_cluster#update EksCluster#update}
    */
    readonly update?: string;
}
export declare function eksClusterTimeoutsToTerraform(struct?: EksClusterTimeoutsOutputReference | EksClusterTimeouts | cdktf.IResolvable): any;
export declare class EksClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EksClusterTimeouts | undefined;
    set internalValue(value: EksClusterTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface EksClusterVpcConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/eks_cluster#endpoint_private_access EksCluster#endpoint_private_access}
    */
    readonly endpointPrivateAccess?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/eks_cluster#endpoint_public_access EksCluster#endpoint_public_access}
    */
    readonly endpointPublicAccess?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/eks_cluster#public_access_cidrs EksCluster#public_access_cidrs}
    */
    readonly publicAccessCidrs?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/eks_cluster#security_group_ids EksCluster#security_group_ids}
    */
    readonly securityGroupIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/eks_cluster#subnet_ids EksCluster#subnet_ids}
    */
    readonly subnetIds: string[];
}
export declare function eksClusterVpcConfigToTerraform(struct?: EksClusterVpcConfigOutputReference | EksClusterVpcConfig): any;
export declare class EksClusterVpcConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EksClusterVpcConfig | undefined;
    set internalValue(value: EksClusterVpcConfig | undefined);
    get clusterSecurityGroupId(): string;
    private _endpointPrivateAccess?;
    get endpointPrivateAccess(): boolean | cdktf.IResolvable;
    set endpointPrivateAccess(value: boolean | cdktf.IResolvable);
    resetEndpointPrivateAccess(): void;
    get endpointPrivateAccessInput(): boolean | cdktf.IResolvable | undefined;
    private _endpointPublicAccess?;
    get endpointPublicAccess(): boolean | cdktf.IResolvable;
    set endpointPublicAccess(value: boolean | cdktf.IResolvable);
    resetEndpointPublicAccess(): void;
    get endpointPublicAccessInput(): boolean | cdktf.IResolvable | undefined;
    private _publicAccessCidrs?;
    get publicAccessCidrs(): string[];
    set publicAccessCidrs(value: string[]);
    resetPublicAccessCidrs(): void;
    get publicAccessCidrsInput(): string[] | undefined;
    private _securityGroupIds?;
    get securityGroupIds(): string[];
    set securityGroupIds(value: string[]);
    resetSecurityGroupIds(): void;
    get securityGroupIdsInput(): string[] | undefined;
    private _subnetIds?;
    get subnetIds(): string[];
    set subnetIds(value: string[]);
    get subnetIdsInput(): string[] | undefined;
    get vpcId(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/eks_cluster aws_eks_cluster}
*/
export declare class EksCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_eks_cluster";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/eks_cluster aws_eks_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options EksClusterConfig
    */
    constructor(scope: Construct, id: string, config: EksClusterConfig);
    get arn(): string;
    private _certificateAuthority;
    get certificateAuthority(): EksClusterCertificateAuthorityList;
    get createdAt(): string;
    private _enabledClusterLogTypes?;
    get enabledClusterLogTypes(): string[];
    set enabledClusterLogTypes(value: string[]);
    resetEnabledClusterLogTypes(): void;
    get enabledClusterLogTypesInput(): string[] | undefined;
    get endpoint(): string;
    get id(): string;
    private _identity;
    get identity(): EksClusterIdentityList;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get platformVersion(): string;
    private _roleArn?;
    get roleArn(): string;
    set roleArn(value: string);
    get roleArnInput(): string | undefined;
    get status(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tagsAll?;
    get tagsAll(): {
        [key: string]: string;
    };
    set tagsAll(value: {
        [key: string]: string;
    });
    resetTagsAll(): void;
    get tagsAllInput(): {
        [key: string]: string;
    } | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
    private _encryptionConfig;
    get encryptionConfig(): EksClusterEncryptionConfigOutputReference;
    putEncryptionConfig(value: EksClusterEncryptionConfig): void;
    resetEncryptionConfig(): void;
    get encryptionConfigInput(): EksClusterEncryptionConfig | undefined;
    private _kubernetesNetworkConfig;
    get kubernetesNetworkConfig(): EksClusterKubernetesNetworkConfigOutputReference;
    putKubernetesNetworkConfig(value: EksClusterKubernetesNetworkConfig): void;
    resetKubernetesNetworkConfig(): void;
    get kubernetesNetworkConfigInput(): EksClusterKubernetesNetworkConfig | undefined;
    private _timeouts;
    get timeouts(): EksClusterTimeoutsOutputReference;
    putTimeouts(value: EksClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): EksClusterTimeouts | undefined;
    private _vpcConfig;
    get vpcConfig(): EksClusterVpcConfigOutputReference;
    putVpcConfig(value: EksClusterVpcConfig): void;
    get vpcConfigInput(): EksClusterVpcConfig | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=eks-cluster.d.ts.map