import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS ElastiCache
*/
export interface DataAwsElasticacheClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/elasticache_cluster#cluster_id DataAwsElasticacheCluster#cluster_id}
    */
    readonly clusterId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/elasticache_cluster#tags DataAwsElasticacheCluster#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
}
export interface DataAwsElasticacheClusterCacheNodes {
}
export declare function dataAwsElasticacheClusterCacheNodesToTerraform(struct?: DataAwsElasticacheClusterCacheNodes): any;
export declare class DataAwsElasticacheClusterCacheNodesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsElasticacheClusterCacheNodes | undefined;
    set internalValue(value: DataAwsElasticacheClusterCacheNodes | undefined);
    get address(): string;
    get availabilityZone(): string;
    get id(): string;
    get port(): number;
}
export declare class DataAwsElasticacheClusterCacheNodesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsElasticacheClusterCacheNodesOutputReference;
}
export interface DataAwsElasticacheClusterLogDeliveryConfiguration {
}
export declare function dataAwsElasticacheClusterLogDeliveryConfigurationToTerraform(struct?: DataAwsElasticacheClusterLogDeliveryConfiguration): any;
export declare class DataAwsElasticacheClusterLogDeliveryConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsElasticacheClusterLogDeliveryConfiguration | undefined;
    set internalValue(value: DataAwsElasticacheClusterLogDeliveryConfiguration | undefined);
    get destination(): string;
    get destinationType(): string;
    get logFormat(): string;
    get logType(): string;
}
export declare class DataAwsElasticacheClusterLogDeliveryConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsElasticacheClusterLogDeliveryConfigurationOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/elasticache_cluster aws_elasticache_cluster}
*/
export declare class DataAwsElasticacheCluster extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_elasticache_cluster";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/elasticache_cluster aws_elasticache_cluster} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsElasticacheClusterConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsElasticacheClusterConfig);
    get arn(): string;
    get availabilityZone(): string;
    private _cacheNodes;
    get cacheNodes(): DataAwsElasticacheClusterCacheNodesList;
    get clusterAddress(): string;
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    get clusterIdInput(): string | undefined;
    get configurationEndpoint(): string;
    get engine(): string;
    get engineVersion(): string;
    get id(): string;
    private _logDeliveryConfiguration;
    get logDeliveryConfiguration(): DataAwsElasticacheClusterLogDeliveryConfigurationList;
    get maintenanceWindow(): string;
    get nodeType(): string;
    get notificationTopicArn(): string;
    get numCacheNodes(): number;
    get parameterGroupName(): string;
    get port(): number;
    get replicationGroupId(): string;
    get securityGroupIds(): string[];
    get securityGroupNames(): string[];
    get snapshotRetentionLimit(): number;
    get snapshotWindow(): string;
    get subnetGroupName(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-elasticache-cluster.d.ts.map